/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.HotShotEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class HotShot
extends BaseGun {
    public HotShot(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_CANNON_FIRE_1_SHORT.get();
    }

    @Override
    protected float getFiringSoundPitchAdjust() {
        return 0.7f;
    }

    @Override
    public boolean isFullAutomatic() {
        return false;
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAItems.METAL_SLUG.get();
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new HotShotEntity(shooter, this, hand, 120, 0);
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPos, float bulletDmgMultiplier) {
        AreaEffectCloud cloud = new AreaEffectCloud(bullet.level(), (target.getX() + bullet.getX()) / 2.0, (target.getY() + bullet.getY()) / 2.0, (target.getZ() + bullet.getZ()) / 2.0);
        cloud.setOwner(shooter);
        cloud.setParticle((ParticleOptions)ParticleTypes.FLAME);
        cloud.setRadius(1.0f);
        cloud.setDuration(5);
        cloud.setRadiusPerTick(0.4f);
        cloud.setWaitTime(0);
        bullet.level().addFreshEntity((Entity)cloud);
        for (LivingEntity entity : bullet.level().getEntitiesOfClass(LivingEntity.class, cloud.getBoundingBox().inflate(2.0, 1.0, 2.0), EntityUtil::isHostileMob)) {
            entity.igniteForSeconds(4.0f);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

