/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class GoldenFury
extends BaseGun {
    public GoldenFury(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_GENERIC_FIRE_3.get();
    }

    @Override
    protected void doFiringEffects(ServerLevel level, LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        super.doFiringEffects(level, shooter, bullet, stack, hand);
        for (int i = 0; i < 6; ++i) {
            ((ServerLevel)shooter.level()).sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, bullet.getX() + RandomUtil.randomScaledGaussianValue((double)0.2f), bullet.getY() + RandomUtil.randomScaledGaussianValue((double)0.2f), bullet.getZ() + RandomUtil.randomScaledGaussianValue((double)0.2f), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPos, float bulletDmgMultiplier) {
        AreaEffectCloud cloud = new AreaEffectCloud(bullet.level(), (target.getX() + bullet.getX()) / 2.0, (target.getY() + bullet.getY()) / 2.0, (target.getZ() + bullet.getZ()) / 2.0);
        cloud.setOwner(shooter);
        cloud.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
        cloud.setRadius(1.0f);
        cloud.setDuration(20);
        cloud.setRadiusPerTick((5.0f - cloud.getRadius()) / (float)cloud.getDuration());
        cloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 0));
        bullet.level().addFreshEntity((Entity)cloud);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

