/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.scheduling.async.EchoGullTask;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class EchoGull
extends BaseGun {
    public EchoGull(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_GENERIC_FIRE_5.get();
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPos, float bulletDmgMultiplier) {
        ArrayList<Tuple<LivingEntity, Integer>> entityList = new ArrayList<Tuple<LivingEntity, Integer>>();
        block0: for (LivingEntity entity : bullet.level().getEntitiesOfClass(LivingEntity.class, bullet.getBoundingBox().inflate(30.0), EntityUtil::isHostileMob)) {
            int distance = (int)entity.distanceTo((Entity)bullet);
            if (entityList.isEmpty()) {
                entityList.add((Tuple<LivingEntity, Integer>)new Tuple((Object)entity, (Object)distance));
                continue;
            }
            for (int i = 0; i < entityList.size(); ++i) {
                int dist = (Integer)entityList.get(i).getB();
                if (dist != distance && dist <= distance) continue;
                entityList.add(i, (Tuple<LivingEntity, Integer>)new Tuple((Object)entity, (Object)distance));
                continue block0;
            }
        }
        AoAScheduler.scheduleSyncronisedTask(new EchoGullTask(bullet.level(), entityList), 1);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

