/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.GunRecoilPacket;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.LimoniteBulletEntity;
import net.tslat.aoa3.content.item.datacomponent.GunStats;
import net.tslat.aoa3.content.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EnchantmentUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGun
extends Item {
    public static final UUID BRACE_DEBUFF = UUID.fromString("a1371c64-c09e-4ed6-adfd-5afbaea79369");
    public static final UUID ATTACK_SPEED_MAINHAND = UUID.fromString("99fdc256-279e-4c8e-b1c6-9209571f134e");

    public BaseGun(Item.Properties properties) {
        super(properties);
    }

    public GunStats getGunStats() {
        return this.getGunStats(this.getDefaultInstance());
    }

    public GunStats getGunStats(ItemStack stack) {
        GunStats stats = (GunStats)stack.get(AoADataComponents.GUN_STATS);
        return stats != null ? stats : this.getGunStats();
    }

    public float getGunDamage(ItemStack stack) {
        return this.getGunStats(stack).damage();
    }

    public float getRecoilModifier(ItemStack stack) {
        return this.getGunStats(stack).recoilModifier();
    }

    public int getTicksBetweenShots(ItemStack stack) {
        return this.getGunStats(stack).ticksBetweenShots();
    }

    private double getUnholsterTimeModifier(ItemStack stack) {
        return this.getGunStats(stack).unholsterTimeModifier();
    }

    @Nullable
    public SoundEvent getFiringSound() {
        return null;
    }

    protected float getFiringSoundPitchAdjust() {
        return 1.0f;
    }

    public float getRecoilForShot(ItemStack stack, LivingEntity shooter) {
        return (this.getGunDamage(stack) == 0.0f ? 1.0f : (float)Math.pow(this.getGunDamage(stack), 1.4f)) * this.getRecoilModifier(stack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public int getEnchantmentValue() {
        return 8;
    }

    public Item getAmmoItem() {
        return (Item)AoAItems.LIMONITE_BULLET.get();
    }

    public InteractionHand getGunHand(Level level, ItemStack stack) {
        return EnchantmentUtil.hasEnchantment(level, stack, AoAEnchantments.BRACE) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean isFullAutomatic() {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Item mainItem;
        ItemStack stack = player.getItemInHand(hand);
        if (hand != this.getGunHand(level, stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (player.isUsingItem() && player.isBlocking()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.getAttackStrengthScale(0.0f) < 1.0f) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (hand == InteractionHand.OFF_HAND && player.isShiftKeyDown() && ((mainItem = player.getItemInHand(InteractionHand.MAIN_HAND).getItem()) instanceof BaseSniper || mainItem instanceof BaseStaff)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.pass((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity shooter, ItemStack stack, int count) {
        if (!this.isFullAutomatic() && count < this.getUseDuration(stack, shooter)) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerPlayer player;
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer serverPlayer = player = shooter instanceof ServerPlayer ? (ServerPlayer)shooter : null;
            if (player == null || player.getCooldowns().getCooldownPercent((Item)this, 0.0f) == 0.0f) {
                InteractionHand hand = this.getGunHand(level, stack);
                if (this.fireGun(serverLevel, shooter, stack, hand)) {
                    ItemStack offhand;
                    if (hand == InteractionHand.MAIN_HAND && EnchantmentUtil.hasEnchantment(level, offhand = shooter.getOffhandItem(), AoAEnchantments.BRACE)) {
                        offhand.onUseTick((Level)serverLevel, shooter, count);
                    }
                    ItemUtil.damageItemForUser(serverLevel, stack, shooter, hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND);
                    if (player != null) {
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                        if (this.getTicksBetweenShots(stack) > 1) {
                            player.getCooldowns().addCooldown((Item)this, this.getTicksBetweenShots(stack));
                        }
                        this.doRecoil(player, stack, hand);
                    }
                } else {
                    shooter.releaseUsingItem();
                }
            }
        }
    }

    protected boolean fireGun(ServerLevel level, LivingEntity shooter, ItemStack stack, InteractionHand hand) {
        BaseBullet bullet = this.findAndConsumeAmmo(shooter, stack, hand);
        if (bullet == null) {
            return false;
        }
        shooter.level().addFreshEntity((Entity)bullet);
        this.doFiringEffects(level, shooter, bullet, stack, hand);
        return true;
    }

    public void doRecoil(ServerPlayer player, ItemStack stack, InteractionHand hand) {
        float recoilAmount = AoAEnchantments.modifyRecoil(player.serverLevel(), stack, this.getRecoilForShot(stack, (LivingEntity)player) * 2.0f);
        AoANetworking.sendToPlayer(player, new GunRecoilPacket(hand == InteractionHand.OFF_HAND ? recoilAmount * 1.25f : recoilAmount));
    }

    protected void doFiringEffects(ServerLevel level, LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        this.doFiringSound(shooter, bullet, stack, hand);
        level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, bullet.getX(), bullet.getY(), bullet.getZ(), 2, 0.0, 0.0, 0.0, (double)0.025f);
        float gunDamage = this.getGunDamage(stack);
        if (gunDamage > 15.0f) {
            if (gunDamage > 20.0f) {
                level.sendParticles((ParticleOptions)ParticleTypes.FLAME, bullet.getX(), bullet.getY(), bullet.getZ(), 2, 0.0, 0.0, 0.0, (double)0.025f);
            }
            level.sendParticles((ParticleOptions)ParticleTypes.POOF, bullet.getX(), bullet.getY(), bullet.getZ(), 2, 0.0, 0.0, 0.0, (double)0.025f);
        }
    }

    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPosition, float bulletDmgMultiplier) {
        Level level;
        if (target != null && (level = target.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ItemStack stack = shooter.getItemInHand(bullet.getHand());
            float damage = this.getGunDamage(stack) * bulletDmgMultiplier;
            if (!stack.is((Item)this)) {
                stack = this.getDefaultInstance();
            }
            ItemStack gunStack = stack;
            if (RandomUtil.percentChance((float)((float)this.getTicksBetweenShots(stack) / 10.0f))) {
                if (DamageUtil.doHeavyGunAttack((Entity)shooter, (Entity)bullet, target, source -> Float.valueOf(EnchantmentHelper.modifyDamage((ServerLevel)level2, (ItemStack)gunStack, (Entity)target, (DamageSource)source, (float)damage)))) {
                    this.doImpactEffect(target, shooter, bullet, impactPosition, bulletDmgMultiplier);
                }
            } else if (DamageUtil.doGunAttack((Entity)shooter, (Entity)bullet, target, source -> Float.valueOf(EnchantmentHelper.modifyDamage((ServerLevel)level2, (ItemStack)gunStack, (Entity)target, (DamageSource)source, (float)damage)))) {
                this.doImpactEffect(target, shooter, bullet, impactPosition, bulletDmgMultiplier);
            }
        }
    }

    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPos, float bulletDmgMultiplier) {
    }

    protected void doFiringSound(LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        if (this.getFiringSound() != null) {
            new SoundBuilder(this.getFiringSound()).isPlayer().pitch(this.getFiringSoundPitchAdjust()).varyPitch(0.075f).followEntity((Entity)shooter).execute();
        }
    }

    @Nullable
    public BaseBullet findAndConsumeAmmo(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        Player pl;
        if (!(shooter instanceof Player) || InventoryUtil.findItemForConsumption(pl = (Player)shooter, (ItemLike)this.getAmmoItem(), pl.getAbilities().instabuild ? 0 : AoAEnchantments.modifyAmmoCost(pl.level(), gunStack, 1), true)) {
            return this.createProjectileEntity(shooter, gunStack, hand);
        }
        return null;
    }

    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new LimoniteBulletEntity(shooter, this, hand, 120, 0);
    }

    public static ItemAttributeModifiers createGunAttributeModifiers(double holsterSpeed) {
        ImmutableList.Builder entries = ImmutableList.builder();
        entries.add((Object)new ItemAttributeModifiers.Entry(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -holsterSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.MAINHAND));
        entries.add((Object)new ItemAttributeModifiers.Entry(Attributes.MOVEMENT_SPEED, new AttributeModifier(AdventOfAscension.id("brace_debuff"), -0.35, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.OFFHAND));
        return new ItemAttributeModifiers((List)entries.build(), false);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        float damage = this.getGunDamage(stack);
        if (damage > 0.0f) {
            tooltip.add(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.GUN_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(damage, 2))}));
        }
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.FIRING_SPEED, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(20.0f / (float)this.getTicksBetweenShots(stack), 2))}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.AMMO_ITEM, LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, this.getAmmoItem().getDescription()));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(this.isFullAutomatic() ? LocaleUtil.Keys.FULLY_AUTOMATIC_GUN : LocaleUtil.Keys.SEMI_AUTOMATIC_GUN, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
    }
}

