/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.greatblade;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.item.weapon.greatblade.BaseGreatblade;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class PlutonScythe
extends BaseGreatblade {
    public static final UUID LUCK_BUFF = UUID.fromString("e446949b-1792-4a66-8f83-5037d6dcce9b");

    public PlutonScythe(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public static Item.Properties baseProperties(Tier tier, float attackSpeed) {
        return new Item.Properties().attributes(BaseGreatblade.createAttributes(tier, 0.0f, attackSpeed).withModifierAdded(Attributes.LUCK, new AttributeModifier(AdventOfAscension.id("pluton_scythe"), 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        AoAResource.Instance spirit;
        float consumeAmount;
        if (!attacker.level().isClientSide && (consumeAmount = ((spirit = target instanceof ServerPlayer ? PlayerUtil.getResource((Player)((ServerPlayer)target), (AoAResource)AoAResources.SPIRIT.get()) : null) != null ? Math.min(50.0f, spirit.getCurrentValue()) : 50.0f) * attackCooldown) > 0.0f) {
            if (spirit != null && !spirit.consume(consumeAmount, true)) {
                return;
            }
            if (attacker instanceof ServerPlayer) {
                PlayerUtil.addResourceToPlayer((ServerPlayer)attacker, (AoAResource)AoAResources.SPIRIT.get(), consumeAmount);
            }
        }
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().build();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.LEECHES_SPIRIT, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
    }
}

