/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.greatblade;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.content.item.weapon.greatblade.BaseGreatblade;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class MillenniumGreatblade
extends BaseGreatblade {
    private final double maxDmg = this.getTier().getAttackDamageBonus() * 3.0f;

    public MillenniumGreatblade(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public float getDamageForAttack(LivingEntity target, LivingEntity attacker, ItemStack greatblade, DamageSource source, float baseDamage) {
        return super.getDamageForAttack(target, attacker, greatblade, source, baseDamage + (float)RandomUtil.randomValueUpTo((double)(this.maxDmg - Math.min((double)baseDamage, this.maxDmg))) * MillenniumGreatblade.getSwingEffectiveness(greatblade));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.RANDOM_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)NumberUtil.roundTo2Decimals(this.getBaseDamage(stack) + 1.0f)), Component.literal((String)NumberUtil.roundTo2Decimals((float)this.maxDmg))}));
    }
}

