/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.greatblade;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;

public class BaseGreatblade
extends BaseSword {
    protected static final ResourceLocation BASE_ATTACK_REACH_ID = AdventOfAscension.id("greatblade_attack_reach");

    public BaseGreatblade(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(Blocks.COBWEB)) {
            return 25.0f;
        }
        return state.is(BlockTags.SWORD_EFFICIENT) ? 2.0f : 1.0f;
    }

    public static Item.Properties baseProperties(Tier tier) {
        return BaseGreatblade.baseProperties(tier, -3.24f);
    }

    public static Item.Properties baseProperties(Tier tier, float attackSpeed) {
        return BaseGreatblade.baseProperties(tier, 0.0f, attackSpeed);
    }

    public static Item.Properties baseProperties(Tier tier, float attackDamageMod, float attackSpeed) {
        return new Item.Properties().attributes(BaseGreatblade.createAttributes(tier, attackDamageMod, attackSpeed));
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, float attackSpeed) {
        return BaseGreatblade.createAttributes((Tier)tier, (int)0, (float)attackSpeed);
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, float attackDamageMod, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(attackDamageMod + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(BASE_ATTACK_REACH_ID, 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }
}

