/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.crossbow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.item.weapon.crossbow.BaseCrossbow;
import net.tslat.aoa3.util.EnchantmentUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class SpectralCrossbow
extends BaseCrossbow {
    public SpectralCrossbow(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected ItemStack getAmmoStack(LivingEntity shooter, ItemStack crossbowStack) {
        return new ItemStack((ItemLike)Items.ARROW, Math.max(1, EnchantmentUtil.getEnchantmentLevel(shooter.level(), crossbowStack, (ResourceKey<Enchantment>)Enchantments.MULTISHOT)));
    }

    @Override
    public CustomArrowEntity applyArrowMods(CustomArrowEntity arrow, @Nullable Entity shooter, ItemStack stack, boolean isCritical) {
        arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        return arrow;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.ARROW_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)Double.toString(this.getCrossbowDamage(stack)))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        List projectiles = ((ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES)).getItems();
        if (SpectralCrossbow.isCharged((ItemStack)stack) && !projectiles.isEmpty()) {
            ItemStack projectile = (ItemStack)projectiles.get(0);
            tooltip.add((Component)Component.translatable((String)"item.minecraft.crossbow.projectile").append(" ").append(projectile.getDisplayName()));
            if (flag.isAdvanced() && projectile.getItem() == Items.FIREWORK_ROCKET) {
                ArrayList list1 = Lists.newArrayList();
                Items.FIREWORK_ROCKET.appendHoverText(projectile, context, (List)list1, flag);
                if (!list1.isEmpty()) {
                    list1.replaceAll(element -> Component.literal((String)"  ").append(element).withStyle(ChatFormatting.GRAY));
                    tooltip.addAll(list1);
                }
            }
        }
    }
}

