/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class SpectralBow
extends BaseBow {
    public SpectralBow(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected ItemStack findAmmo(Player shooter, ItemStack bowStack, boolean infiniteAmmo) {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    @Override
    public CustomArrowEntity applyArrowMods(CustomArrowEntity arrow, @Nullable Entity shooter, ItemStack stack, boolean isCritical) {
        arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        return arrow;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.ARROW_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)Double.toString(this.getBowDamage(stack)))}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.BOW_DRAW_TIME, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.literal((String)Double.toString((double)((int)(72000.0f / this.getDrawSpeedMultiplier(stack)) / 720) / 100.0))}));
    }
}

