/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import org.jetbrains.annotations.Nullable;

public class SoulfireBow
extends BaseBow {
    public SoulfireBow(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected CustomArrowEntity makeArrow(LivingEntity shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        ServerPlayer pl;
        CustomArrowEntity arrow = super.makeArrow(shooter, bowStack, ammoStack, velocity, consumeAmmo);
        if (arrow != null && shooter instanceof ServerPlayer && PlayerUtil.consumeResource(pl = (ServerPlayer)shooter, (AoAResource)AoAResources.SPIRIT.get(), 200.0f, false)) {
            arrow.setGlowingTag(true);
        }
        return arrow;
    }

    @Override
    public void onEntityImpact(CustomArrowEntity arrow, @Nullable Entity shooter, EntityHitResult hitResult, ItemStack stack, float velocity) {
        if (arrow.isCurrentlyGlowing() && shooter instanceof LivingEntity) {
            LivingEntity livingShooter = (LivingEntity)shooter;
            EntityUtil.healEntity(livingShooter, 8.0f);
        }
        arrow.setGlowingTag(false);
    }

    @Override
    public void onBlockImpact(CustomArrowEntity arrow, @Nullable Entity shooter, BlockHitResult hitResult, ItemStack stack) {
        arrow.setGlowingTag(false);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

