/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.util.LocaleUtil;

public class NightmareBow
extends BaseBow {
    public NightmareBow(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected CustomArrowEntity makeArrow(LivingEntity shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        double xOffset = Mth.cos((float)(shooter.getYRot() / 180.0f * (float)Math.PI)) * 0.7f;
        double zOffset = Mth.sin((float)(shooter.getYRot() / 180.0f * (float)Math.PI)) * 0.7f;
        CustomArrowEntity centralArrow = super.makeArrow(shooter, bowStack, ammoStack, velocity, consumeAmmo);
        CustomArrowEntity leftArrow = CustomArrowEntity.fromArrow((AbstractArrow)centralArrow, bowStack, shooter, this.getBowDamage(bowStack));
        CustomArrowEntity rightArrow = CustomArrowEntity.fromArrow((AbstractArrow)centralArrow, bowStack, shooter, this.getBowDamage(bowStack));
        leftArrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        rightArrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        leftArrow.teleportTo(leftArrow.getX() + xOffset, leftArrow.getY(), leftArrow.getZ() + zOffset);
        rightArrow.teleportTo(rightArrow.getX() - xOffset, rightArrow.getY(), rightArrow.getZ() - zOffset);
        shooter.level().addFreshEntity((Entity)leftArrow);
        shooter.level().addFreshEntity((Entity)rightArrow);
        return centralArrow;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

