/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.library.object.explosion.StandardExplosion;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class ExplosiveBow
extends BaseBow {
    public ExplosiveBow(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void onEntityImpact(CustomArrowEntity arrow, @Nullable Entity shooter, EntityHitResult hitResult, ItemStack stack, float velocity) {
        Level level;
        if (arrow.isCritArrow() && (level = arrow.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new StandardExplosion(AoAExplosions.EXPLOSIVE_BOW, serverLevel, (Entity)arrow, shooter).explode();
        }
    }

    @Override
    public void onBlockImpact(CustomArrowEntity arrow, @Nullable Entity shooter, BlockHitResult hitResult, ItemStack stack) {
        Level level;
        if (arrow.isCritArrow() && (level = arrow.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new StandardExplosion(AoAExplosions.EXPLOSIVE_BOW, serverLevel, (Entity)arrow, shooter).explode();
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
        for (MutableComponent component : LocaleUtil.getExplosionInfoLocale(AoAExplosions.EXPLOSIVE_BOW, flag.isAdvanced(), false)) {
            tooltip.add(2, (Component)component);
        }
    }
}

