/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class VortexBlaster
extends BaseBlaster {
    public VortexBlaster(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GRAVITY_BLASTER_FIRE.get();
    }

    @Override
    public void fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster) {
        float x = -Mth.sin((float)(shooter.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(shooter.getXRot() / 180.0f * (float)Math.PI));
        float y = -Mth.sin((float)(shooter.getXRot() / 180.0f * (float)Math.PI));
        float z = Mth.cos((float)(shooter.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(shooter.getXRot() / 180.0f * (float)Math.PI));
        for (LivingEntity entity : shooter.level().getEntitiesOfClass(LivingEntity.class, shooter.getBoundingBox().inflate((double)(x * 7.0f + 1.0f), (double)(y * 7.0f + 1.0f), (double)(z * 7.0f + 1.0f)))) {
            DamageUtil.doScaledKnockback(entity, shooter, 7.0f, 1.0, 1.0, 1.0);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

