/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import org.jetbrains.annotations.Nullable;

public class LaserBlaster
extends BaseBlaster {
    public LaserBlaster(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_ILLUSION_SMG_FIRE.get();
    }

    @Override
    public float getBeamDistance(ItemStack stack, @Nullable LivingEntity shooter) {
        return 40.0f;
    }

    @Override
    protected EnergyProjectileWeapon.ShotInfo fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster, boolean temp) {
        return super.fireBlaster(level, shooter, blaster, false);
    }

    @Override
    protected void doFiringEffects(ServerLevel level, LivingEntity shooter, ItemStack stack, EnergyProjectileWeapon.ShotInfo shotInfo) {
        TELParticlePacket packet = new TELParticlePacket();
        Vec3 originPos = shotInfo.shotOrBarrelPosForVfx();
        Vec3 hitPos = shotInfo.getHitPos().orElse(originPos);
        packet.particle(ParticleBuilder.forPositionsInLine((ParticleOptions)ParticleTypes.SONIC_BOOM, (Vec3)originPos, (Vec3)hitPos, (int)6).lifespan(1).ignoreDistanceAndLimits().scaleMod(0.05f).colourOverride(255, 0, 0, 255));
        packet.particle(ParticleBuilder.forPositionsInLine((ParticleOptions)ParticleTypes.END_ROD, (Vec3)originPos, (Vec3)hitPos, (int)6).lifespan(1).ignoreDistanceAndLimits().scaleMod(0.4f).colourOverride(255, 0, 0, 255));
        packet.particle(ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.WARPED_SPORE, (Vec3[])new Vec3[]{hitPos}).lifespan(5).ignoreDistanceAndLimits().colourOverride(255, 0, 0, 255).spawnNTimes(2));
        packet.sendToAllPlayersTrackingEntity(level, (Entity)shooter);
    }
}

