/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class GravityBlaster
extends BaseBlaster {
    public GravityBlaster(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GRAVITY_BLASTER_FIRE.get();
    }

    @Override
    public void fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster) {
        ItemStack stack = shooter.getItemInHand(InteractionHand.MAIN_HAND);
        if (!stack.is((Item)this)) {
            stack = this.getDefaultInstance();
        }
        for (LivingEntity mob : shooter.level().getEntitiesOfClass(LivingEntity.class, shooter.getBoundingBox().inflate(2.0, 0.0, 2.0), EntityUtil::isHostileMob)) {
            EntityUtil.pushEntityAway((Entity)shooter, (Entity)mob, 0.5f);
            DamageUtil.doMiscEnergyAttack((Entity)shooter, (Entity)mob, this.getBlasterDamage(stack), null);
        }
        shooter.hurtMarked = true;
        shooter.push(0.0, 2.0, 0.0);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

