/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import com.google.common.collect.ImmutableList;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.AoASoundBuilderPacket;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import net.tslat.aoa3.content.item.datacomponent.BlasterStats;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.constant.AttackSpeed;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.InteractionResults;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBlaster
extends Item
implements EnergyProjectileWeapon {
    public BaseBlaster(Item.Properties properties) {
        super(properties);
    }

    public BlasterStats blasterStats() {
        return this.blasterStats(this.getDefaultInstance());
    }

    public BlasterStats blasterStats(ItemStack stack) {
        return (BlasterStats)stack.get((DataComponentType)AoADataComponents.BLASTER_STATS.get());
    }

    public float getBlasterDamage(ItemStack stack) {
        return this.blasterStats(stack).damage();
    }

    public int getTicksBetweenShots(ItemStack stack) {
        return this.blasterStats(stack).ticksBetweenShots();
    }

    public int getChargeTime(ItemStack stack) {
        return this.blasterStats(stack).chargeUpTicks();
    }

    public float getBaseSpiritCost(ItemStack stack) {
        return this.blasterStats(stack).spiritCost();
    }

    @Nullable
    public SoundEvent getFiringSound() {
        return null;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand != this.getWeaponHand((LivingEntity)player)) {
            return InteractionResults.ItemUse.denyUsage(stack);
        }
        if (player.getAttackStrengthScale(0.0f) < 1.0f) {
            return InteractionResults.ItemUse.denyUsage(stack);
        }
        float energyCost = this.getSpiritCost(stack, (LivingEntity)player, false);
        if (player.getAbilities().instabuild || PlayerUtil.getResourceValue(player, (AoAResource)AoAResources.SPIRIT.get()) >= energyCost) {
            player.startUsingItem(hand);
            return InteractionResults.ItemUse.noActionTaken(stack);
        }
        if (!player.getAbilities().instabuild) {
            return InteractionResults.ItemUse.denyUsage(stack);
        }
        return InteractionResults.ItemUse.noActionTaken(stack);
    }

    public void onUseTick(Level level, LivingEntity shooter, ItemStack stack, int count) {
        if (this.getUseDuration(stack, shooter) - count < this.getChargeTime(stack) - 2) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerPlayer player;
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer serverPlayer = player = shooter instanceof ServerPlayer ? (ServerPlayer)shooter : null;
            if (player == null || player.getCooldowns().getCooldownPercent((Item)this, 0.0f) == 0.0f) {
                if (this.tryFireBlaster(serverLevel, shooter, stack, player)) {
                    ItemUtil.damageItemForUser(serverLevel, stack, 1, shooter, shooter.getUsedItemHand());
                    if (player != null) {
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                        if (this.getTicksBetweenShots(stack) > 1) {
                            player.getCooldowns().addCooldown((Item)this, this.getTicksBetweenShots(stack));
                        }
                    }
                } else {
                    shooter.releaseUsingItem();
                }
            }
        }
    }

    protected boolean tryFireBlaster(ServerLevel level, LivingEntity shooter, ItemStack stack, @Nullable ServerPlayer playerShooter) {
        float spiritCost = this.getSpiritCost(stack, shooter, false);
        if (spiritCost == 0.0f || this.consumeEnergy(playerShooter, stack, spiritCost)) {
            EnergyProjectileWeapon.ShotInfo shotInfo = this.fireBlaster(level, shooter, stack, true);
            if (shotInfo != null) {
                this.doFiringEffects(level, shooter, stack, shotInfo);
            }
            if (this.getFiringSound() != null) {
                AoANetworking.sendToAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder(this.getFiringSound()).isPlayer().followEntity((Entity)shooter)), (Entity)shooter);
            }
            return true;
        }
        PlayerUtil.notifyPlayerOfInsufficientResources(playerShooter, (AoAResource)AoAResources.SPIRIT.get(), spiritCost);
        return false;
    }

    protected EnergyProjectileWeapon.ShotInfo fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster, boolean isOldBlaster) {
        this.fireBlaster(level, shooter, blaster);
        if (isOldBlaster) {
            return null;
        }
        float beamDistance = this.getBeamDistance(blaster, shooter);
        EnergyProjectileWeapon.ShotInfo shotInfo = this.getPosAndRotForShot(this, shooter, 1.0f, beamDistance);
        Vec3 endPos = shotInfo.position().add(shotInfo.angle().scale((double)beamDistance));
        HitResult rayTrace = PositionAndMotionUtil.rayTrace(shooter.level(), shotInfo.position(), endPos, ClipContext.Block.OUTLINE, true, true, entity -> entity != shooter && entity instanceof LivingEntity);
        shotInfo.setHitPos(rayTrace.getLocation());
        if (rayTrace.getType() != HitResult.Type.MISS) {
            HitResult hitResult = rayTrace;
            Objects.requireNonNull(hitResult);
            HitResult hitResult2 = hitResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHitResult.class, BlockHitResult.class}, (Object)hitResult2, n)) {
                case 0: {
                    EntityHitResult entityHit = (EntityHitResult)hitResult2;
                    shotInfo.setEffectiveHit(this.doEntityImpact(level, shooter, blaster, shotInfo, entityHit));
                    break;
                }
                case 1: {
                    BlockHitResult blockHit = (BlockHitResult)hitResult2;
                    shotInfo.setEffectiveHit(this.doBlockImpact(level, shooter, blaster, shotInfo, blockHit));
                    break;
                }
            }
        }
        return shotInfo;
    }

    protected void fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster) {
    }

    protected void doFiringEffects(ServerLevel level, LivingEntity shooter, ItemStack stack, EnergyProjectileWeapon.ShotInfo shotInfo) {
    }

    public int getBarWidth(ItemStack stack) {
        float chargeProgress = this.getChargeProgress(stack);
        if (chargeProgress > 0.0f) {
            return Mth.floor((float)(chargeProgress * 13.0f));
        }
        return super.getBarWidth(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return super.isBarVisible(stack) || this.getChargeProgress(stack) > 0.0f;
    }

    public int getBarColor(ItemStack stack) {
        float chargeProgress = this.getChargeProgress(stack);
        if (chargeProgress > 0.0f) {
            return 49627;
        }
        return super.getBarColor(stack);
    }

    private float getChargeProgress(ItemStack stack) {
        int chargeTime;
        int useTime;
        Player player;
        if (FMLEnvironment.dist == Dist.CLIENT && (player = ClientOperations.getPlayer()).getUseItem() == stack && (useTime = stack.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks()) < (chargeTime = this.getChargeTime(stack)) - 1) {
            return (float)useTime / (float)(chargeTime - 1);
        }
        return 0.0f;
    }

    public float getSpiritCost(ItemStack stack, @Nullable LivingEntity shooter, boolean forDisplay) {
        Player pl;
        block5: {
            block4: {
                if (!(shooter instanceof Player)) break block4;
                pl = (Player)shooter;
                if (!pl.getAbilities().instabuild || forDisplay) break block5;
            }
            return 0.0f;
        }
        float spiritCost = this.getBaseSpiritCost(stack);
        spiritCost = AoAEnchantments.modifySpiritConsumption(pl.level(), stack, spiritCost);
        spiritCost *= 1.0f + (float)AoAEnchantments.modifyAmmoCost(pl.level(), stack, 0) * 0.3f;
        if (PlayerUtil.isWearingFullSet(pl, AoAArmourMaterials.GHOULISH)) {
            spiritCost *= 0.7f;
        }
        return spiritCost;
    }

    public float getBeamDistance(ItemStack stack, @Nullable LivingEntity shooter) {
        return 30.0f;
    }

    public boolean consumeEnergy(ServerPlayer player, ItemStack stack, float cost) {
        return PlayerUtil.consumeResource(player, (AoAResource)AoAResources.SPIRIT.get(), cost, false);
    }

    @Override
    public InteractionHand getWeaponHand(LivingEntity holder) {
        return InteractionHand.MAIN_HAND;
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity shooter) {
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        ItemStack stack = shooter.getItemInHand(InteractionHand.MAIN_HAND);
        if (!stack.is((Item)this)) {
            stack = this.getDefaultInstance();
        }
        if (DamageUtil.doEnergyProjectileAttack((Entity)shooter, (Entity)shooter, target, this.getBlasterDamage(stack))) {
            this.doImpactEffect(shot, target, shooter);
            return true;
        }
        return false;
    }

    @Override
    public boolean doEntityImpact(ServerLevel level, LivingEntity shooter, ItemStack stack, EnergyProjectileWeapon.ShotInfo shotInfo, EntityHitResult rayTrace) {
        if (DamageUtil.doEnergyProjectileAttack((Entity)shooter, (Entity)shooter, rayTrace.getEntity(), this.getBlasterDamage(stack))) {
            this.doImpactEffect(level, shooter, stack, shotInfo, (HitResult)rayTrace, true);
            return true;
        }
        this.doImpactEffect(level, shooter, stack, shotInfo, (HitResult)rayTrace, false);
        return false;
    }

    @Override
    public boolean doBlockImpact(ServerLevel level, LivingEntity shooter, ItemStack stack, EnergyProjectileWeapon.ShotInfo shotInfo, BlockHitResult rayTrace) {
        this.doImpactEffect(level, shooter, stack, shotInfo, (HitResult)rayTrace, true);
        return true;
    }

    protected void doImpactEffect(ServerLevel level, LivingEntity shooter, ItemStack stack, EnergyProjectileWeapon.ShotInfo shotInfo, HitResult rayTrace, boolean affectedTarget) {
    }

    protected void doImpactEffect(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
    }

    public int getEnchantmentValue() {
        return 8;
    }

    public static ItemAttributeModifiers createBlasterAttributeModifiers(float attacksPerSecond) {
        ImmutableList.Builder entries = ImmutableList.builder();
        entries.add((Object)new ItemAttributeModifiers.Entry(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)AttackSpeed.forAttacksPerSecond(attacksPerSecond), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
        return new ItemAttributeModifiers((List)entries.build(), false);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (this.getBlasterDamage(stack) > 0.0f) {
            tooltip.add(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.ENERGY_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(this.getBlasterDamage(stack), 1))}));
        }
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.BLASTER_CHARGE, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace((float)this.getChargeTime(stack) / 20.0f, 2))}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.BLASTER_PENETRATION, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.FIRING_SPEED, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(20.0f / (float)this.getTicksBetweenShots(stack), 2))}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.AMMO_RESOURCE, LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(this.getSpiritCost(stack, (LivingEntity)(FMLEnvironment.dist == Dist.CLIENT ? ClientOperations.getPlayer() : null), true), 2)), ((AoAResource)AoAResources.SPIRIT.get()).getName()}));
    }
}

