/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.blaster.AtomizerBounceEntity;
import net.tslat.aoa3.content.entity.projectile.blaster.AtomizerShotEntity;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class Atomizer
extends BaseBlaster {
    public Atomizer(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_ATOMIZER_FIRE.get();
    }

    @Override
    public void fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster) {
        shooter.level().addFreshEntity((Entity)new AtomizerShotEntity(shooter, this, 60));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity shooter) {
        if (shot instanceof AtomizerShotEntity) {
            shot.level().addFreshEntity((Entity)new AtomizerBounceEntity(shooter, this, (AtomizerShotEntity)shot, RandomUtil.randomScaledGaussianValue((double)0.5), 1.3, RandomUtil.randomScaledGaussianValue((double)0.5)));
        } else {
            WorldUtil.createExplosion((Entity)shooter, shot.level(), (Entity)shot, 1.5f);
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (super.doEntityImpact(shot, target, shooter)) {
            WorldUtil.createExplosion((Entity)shooter, shot.level(), (Entity)shot, 1.5f);
            if (shot instanceof AtomizerShotEntity) {
                shot.level().addFreshEntity((Entity)new AtomizerBounceEntity(shooter, this, (AtomizerShotEntity)shot, RandomUtil.randomScaledGaussianValue((double)0.5), 1.3, RandomUtil.randomScaledGaussianValue((double)0.5)));
            }
            return true;
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

