/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.shovel;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.item.ChargeableItem;
import net.tslat.aoa3.content.item.tool.shovel.BaseShovel;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class EnergisticShovel
extends BaseShovel
implements ChargeableItem {
    public EnergisticShovel(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public float minRequiredCharge() {
        return 5.0f;
    }

    @Override
    public float maxCharge() {
        return 2000.0f;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        float speed = super.getDestroySpeed(stack, state);
        if (speed != 1.0f && this.hasEnoughCharge(stack)) {
            return speed * 3.0f;
        }
        return speed;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (super.getDestroySpeed(stack, state) != 1.0f) {
            this.subtractCharge(stack, 5.0f, true);
        }
        return super.mineBlock(stack, world, state, pos, entity);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            ItemStack stack = player.getItemInHand(hand);
            AoAResource.Instance spirit = PlayerUtil.getAdventPlayer(pl).getResource((AoAResource)AoAResources.SPIRIT.get());
            float storeAmount = Mth.clamp((float)(2000.0f - this.getCharge(stack)), (float)0.0f, (float)Math.min(20.0f, spirit.getCurrentValue()));
            this.addCharge(stack, storeAmount);
            spirit.consume(storeAmount, true);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(world, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.ENERGISTIC_TOOL_CHARGE, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.ENERGISTIC_TOOL_STORED, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.literal((String)Integer.toString((int)this.getCharge(stack)))}));
    }
}

