/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.artifice;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.tool.artifice.ArtificeItem;
import net.tslat.aoa3.library.object.CachedEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.api.particle.transitionworker.ParticleTransitionWorker;
import net.tslat.effectslib.api.particle.transitionworker.PositionParticleTransition;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.util.RandomUtil;

public class StasisCapsule
extends ArtificeItem {
    public StasisCapsule() {
        super(new Item.Properties().stacksTo(1).component(AoADataComponents.STORED_ENTITY, CachedEntity.EMPTY));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (!((CachedEntity)stack.get(AoADataComponents.STORED_ENTITY)).isEmpty() || !StasisCapsule.canCapture(player, interactionTarget)) {
            return InteractionResult.FAIL;
        }
        if (!player.level().isClientSide) {
            TELParticlePacket packet = new TELParticlePacket();
            packet.particle(ParticleBuilder.forRandomPosAtBoundsEdge((ParticleOptions)ParticleTypes.END_ROD, (AABB)interactionTarget.getBoundingBox().inflate((double)(Math.max(interactionTarget.getBbHeight(), interactionTarget.getBbWidth()) / 2.0f))).spawnNTimes(200).addTransition((ParticleTransitionWorker)PositionParticleTransition.create((Vec3)interactionTarget.position().add(0.0, (double)(interactionTarget.getBbHeight() * 0.5f), 0.0), (int)5)).colourOverride(0.65f, 0.0f, 0.15f, 1.0f).lifespan(10));
            packet.particle(ParticleBuilder.forRandomPosAtBoundsEdge((ParticleOptions)ParticleTypes.ENCHANTED_HIT, (AABB)interactionTarget.getBoundingBox().inflate((double)(Math.max(interactionTarget.getBbHeight(), interactionTarget.getBbWidth()) / 2.0f))).spawnNTimes(200).lifespan(10).colourOverride(1.0f, 1.0f, 1.0f, 1.0f).addTransition((ParticleTransitionWorker)PositionParticleTransition.create((Vec3)interactionTarget.position().add(0.0, (double)(interactionTarget.getBbHeight() * 0.5f), 0.0), (int)5)));
            for (int i = 0; i < 10; ++i) {
                packet.particle(ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (Vec3[])new Vec3[]{interactionTarget.position().add(0.0, (double)(interactionTarget.getBbHeight() * 0.5f), 0.0)}).spawnNTimes(10).velocity(RandomUtil.randomScaledGaussianValue((double)0.05f), RandomUtil.randomScaledGaussianValue((double)0.05f), RandomUtil.randomScaledGaussianValue((double)0.05f)).scaleMod(0.25f).lifespan(RandomUtil.randomNumberBetween((int)20, (int)35)));
            }
            packet.sendToAllPlayersTrackingEntity((ServerLevel)player.level(), (Entity)interactionTarget);
            player.level().playSound(null, interactionTarget.getX(), interactionTarget.getY(), interactionTarget.getZ(), (Holder)SoundEvents.BREEZE_WIND_CHARGE_BURST, SoundSource.PLAYERS, 0.5f, (float)RandomUtil.randomValueBetween((double)0.9f, (double)1.1f));
            player.level().playSound(null, interactionTarget.getX(), interactionTarget.getY(), interactionTarget.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, (float)RandomUtil.randomValueBetween((double)0.9f, (double)1.1f));
            stack.set(AoADataComponents.STORED_ENTITY, CachedEntity.store(interactionTarget));
            player.setItemInHand(usedHand, stack);
            interactionTarget.discard();
        }
        return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        CachedEntity cachedEntity = (CachedEntity)context.getItemInHand().get(AoADataComponents.STORED_ENTITY);
        if (cachedEntity.isEmpty()) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        Level level = context.getLevel();
        Vec3 pos = context.getClickLocation();
        if (!level.noCollision(cachedEntity.entityType().getSpawnAABB(pos.x, pos.y, pos.z))) {
            if (!level.isClientSide()) {
                PlayerUtil.notifyPlayer(player, (Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("spawnEntity.noSpace"), ChatFormatting.RED, new Component[0]));
            }
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            Object entity = cachedEntity.createEntity(level);
            if (entity == null) {
                PlayerUtil.notifyPlayer(player, (Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("spawnEntity.fail"), ChatFormatting.RED, new Component[0]));
                return InteractionResult.FAIL;
            }
            entity.setPos(pos);
            level.addFreshEntity(entity);
            context.getItemInHand().set(AoADataComponents.STORED_ENTITY, CachedEntity.EMPTY);
            TELParticlePacket packet = new TELParticlePacket();
            for (int i = 0; i < 50; ++i) {
                packet.particle(ParticleBuilder.forRandomPosInSphere((ParticleOptions)ParticleTypes.FALLING_SPORE_BLOSSOM, (Vec3)entity.position().add(0.0, (double)(entity.getBbHeight() * 0.5f), 0.0), (double)0.25).colourOverride(0.8f, 0.3f, 0.3f, 1.0f).velocity(RandomUtil.randomScaledGaussianValue((double)0.05f), RandomUtil.randomScaledGaussianValue((double)0.05f), RandomUtil.randomScaledGaussianValue((double)0.05f)).lifespan(RandomUtil.randomNumberBetween((int)20, (int)35)));
            }
            packet.sendToAllPlayersTrackingEntity((ServerLevel)level, (Entity)player);
            level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.8f, 1.8f);
            level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.SPLASH_POTION_BREAK, SoundSource.PLAYERS, 1.0f, 1.8f);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static boolean canCapture(Player player, LivingEntity entity) {
        NeutralMob neutral;
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            if (player.getUUID().equals(ownable.getOwnerUUID()) || ownable.getOwnerUUID() == null) {
                return true;
            }
        }
        return entity instanceof Animal && (!(entity instanceof NeutralMob) || !(neutral = (NeutralMob)entity).isAngryAt((LivingEntity)player));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CachedEntity cachedEntity = (CachedEntity)stack.get(AoADataComponents.STORED_ENTITY);
        if (cachedEntity.isEmpty()) {
            tooltipComponents.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, 1, new Component[0]));
        } else {
            tooltipComponents.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.SPECIAL, 2, cachedEntity.getName(context.registries())));
        }
    }
}

