/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.artifice;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.ChargeableItem;
import net.tslat.aoa3.content.item.tool.artifice.ArtificeItem;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.util.RandomUtil;

public class ExpFlask
extends ArtificeItem
implements ChargeableItem {
    public ExpFlask() {
        super(new Item.Properties().stacksTo(1).component(AoADataComponents.CHARGE, (Object)Float.valueOf(0.0f)));
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 100;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            if (!this.hasEnoughCharge(stack)) {
                return InteractionResultHolder.fail((Object)stack);
            }
            player.startUsingItem(hand);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float charge = this.getCharge(stack);
            if (charge > 0.0f) {
                int xpChange = (int)Math.min((float)(1 + (int)((float)player.experienceLevel / 15.0f)), charge);
                player.giveExperiencePoints(xpChange);
                this.subtractCharge(stack, xpChange, true);
                ParticleBuilder.forRandomPosInEntity((ParticleOptions)((ParticleOptions)AoAParticleTypes.ORB.get()), (Entity)player).colourOverride((Mth.sin((float)((float)entity.tickCount / 2.0f)) + 1.0f) * 0.5f, 1.0f, (Mth.sin((float)((float)entity.tickCount / 2.0f + 4.1887903f)) + 1.0f) * 0.1f, 0.5f).lifespan(RandomUtil.randomNumberBetween((int)30, (int)70)).scaleMod((float)RandomUtil.randomValueBetween((double)0.5, (double)1.25)).sendToAllPlayersTrackingEntity(player.serverLevel(), (Entity)player);
                if (!this.hasEnoughCharge(stack)) {
                    player.stopUsingItem();
                }
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        int storedValue = (int)this.getCharge(stack);
        if (storedValue > 0) {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.SPECIAL, 1, new Component[]{Component.literal((String)(NumberUtil.floorAndAppendSuffix(storedValue, true) + (String)(storedValue >= 7 ? " (" + PlayerUtil.getPlayerLevelFromExp(storedValue) + ")" : "")))}));
        }
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 2, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 3, new Component[0]));
    }
}

