/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.integration.patchouli.PatchouliIntegration;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class TornPages
extends Item {
    public TornPages() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack bookStack = player.getItemInHand(hand);
        if (!IntegrationManager.isPatchouliActive()) {
            return InteractionResultHolder.pass((Object)bookStack);
        }
        return PatchouliIntegration.getBookFromStack(bookStack).filter(PatchouliIntegration::isBookLoaded).map(bookId -> {
            if (!level.isClientSide) {
                PlayerUtil.getAdventPlayer((ServerPlayer)((ServerPlayer)player)).storage.addPatchouliBook((ResourceLocation)bookId);
            } else if (IntegrationManager.isPatchouliActive()) {
                PatchouliIntegration.openBook(bookId);
            }
            return InteractionResultHolder.success((Object)bookStack);
        }).orElseGet(() -> InteractionResultHolder.pass((Object)bookStack));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        boolean validBook;
        boolean patchouliIntegrated = IntegrationManager.isPatchouliActive();
        boolean bl = validBook = patchouliIntegrated && PatchouliIntegration.getBookFromStack(stack).filter(PatchouliIntegration::isBookLoaded).isPresent();
        if (!validBook) {
            return;
        }
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, validBook ? LocaleUtil.ItemDescriptionType.NEUTRAL : LocaleUtil.ItemDescriptionType.HARMFUL, validBook ? 1 : 2, new Component[0]));
    }
}

