/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.event.dimension.NowhereEvents;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ReturnCrystal
extends Item {
    public ReturnCrystal() {
        super(new Item.Properties());
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 20;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (WorldUtil.isWorld(world, AoADimensions.NOWHERE)) {
            return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            if (!WorldUtil.isWorld(world, AoADimensions.NOWHERE)) {
                PlayerUtil.notifyPlayer((Player)pl, (Component)LocaleUtil.getLocaleMessage("message.feedback.item.returnCrystal.wrongDim"));
                return stack;
            }
            if (!pl.isCreative()) {
                stack.shrink(1);
            }
            if (!NowhereEvents.isInLobbyRegion(pl.blockPosition())) {
                if (NowhereEvents.isInBossRegion(pl.blockPosition()) && !AdvancementUtil.isAdvancementCompleted(pl, AdventOfAscension.id("nowhere/root"))) {
                    AoAScheduler.scheduleSyncronisedTask(() -> {
                        PlayerUtil.resetToDefaultStatus(pl);
                        pl.connection.teleport(17.5, 452.5, 3.5, 0.0f, pl.getXRot());
                        InventoryUtil.clearItems(pl, new ItemLike[]{AoAItems.RETURN_CRYSTAL});
                        PlayerUtil.getAdventPlayer((ServerPlayer)pl).storage.returnStoredItems();
                    }, 1);
                } else {
                    AoAScheduler.scheduleSyncronisedTask(() -> {
                        PlayerUtil.resetToDefaultStatus(pl);
                        pl.connection.teleport(16.5, 1501.5, 16.5, 180.0f, pl.getXRot());
                        InventoryUtil.clearItems(pl, new ItemLike[]{AoAItems.RETURN_CRYSTAL});
                        PlayerUtil.getAdventPlayer((ServerPlayer)pl).storage.returnStoredItems();
                    }, 1);
                }
            }
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

