/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.content.entity.misc.LottoTotemEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class LottoTotem
extends Item {
    public LottoTotem() {
        super(new Item.Properties());
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState targetBlockState = world.getBlockState(pos);
        if (context.getClickedFace() != Direction.UP || !targetBlockState.isFaceSturdy((BlockGetter)world, pos, Direction.UP)) {
            return InteractionResult.FAIL;
        }
        if (!world.isClientSide) {
            if (!world.getEntitiesOfClass(LottoTotemEntity.class, new AABB(pos).inflate(4.0)).isEmpty()) {
                PlayerUtil.notifyPlayer(player, (Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("lottoTotem.nearby"), ChatFormatting.RED, new Component[0]));
                return InteractionResult.FAIL;
            }
            ArrayList<BlockPos> spawnPositions = new ArrayList<BlockPos>(5);
            spawnPositions.add(pos);
            if (this.populateSpawnPositions(world, pos, spawnPositions)) {
                player.getItemInHand(context.getHand()).shrink(1);
                int selectedWinner = RandomUtil.randomNumberUpTo((int)5);
                UUID winningUUID = Mth.createInsecureUUID();
                for (BlockPos spawnPos : spawnPositions) {
                    LottoTotemEntity totem = new LottoTotemEntity(world, spawnPos, winningUUID, player.getUUID());
                    if (selectedWinner == 0) {
                        totem.setUUID(winningUUID);
                    }
                    world.addFreshEntity((Entity)totem);
                    --selectedWinner;
                }
                PlayerUtil.notifyPlayer(player, (Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("lottoTotem.spawn"), ChatFormatting.GOLD, new Component[0]));
            } else {
                PlayerUtil.notifyPlayer(player, (Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("lottoTotem.noSpace"), ChatFormatting.RED, new Component[0]));
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean populateSpawnPositions(Level world, BlockPos pos, ArrayList<BlockPos> spawnPositions) {
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int x = pos.getX() - 1; x <= pos.getX() + 1; x += 2) {
            for (int z = pos.getZ() - 1; z <= pos.getZ() + 1; z += 2) {
                checkPos.set(x, pos.getY(), z);
                if (!world.getBlockState(checkPos.above()).canBeReplaced() || !world.getBlockState((BlockPos)checkPos).isFaceSturdy((BlockGetter)world, (BlockPos)checkPos, Direction.UP)) continue;
                spawnPositions.add(checkPos.immutable());
                if (spawnPositions.size() < 5) continue;
                return true;
            }
        }
        return false;
    }
}

