/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.util.EffectBuilder;

public class DistortingArtifact
extends Item {
    public DistortingArtifact() {
        super(new Item.Properties().durability(10));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem();
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        LivingEntity user;
        if (!(itemSlot < 9 || entity instanceof LivingEntity && (user = (LivingEntity)entity).getItemInHand(InteractionHand.OFF_HAND) == stack)) {
            return;
        }
        if (!world.isClientSide && stack.getDamageValue() < stack.getMaxDamage() && entity.getY() <= (double)world.getMinBuildHeight()) {
            entity.teleportTo(entity.getX(), 257.0, entity.getZ());
            entity.fallDistance = -255.0f;
            if (entity instanceof LivingEntity) {
                EntityUtil.applyPotions(entity, new EffectBuilder(MobEffects.BLINDNESS, 40).isAmbient().hideParticles());
                if (entity instanceof ServerPlayer) {
                    ServerPlayer pl = (ServerPlayer)entity;
                    ItemUtil.damageItemForUser(pl.serverLevel(), stack, 1, (LivingEntity)pl, item -> {
                        EquipmentSlot slot;
                        Object object = isSelected ? EquipmentSlot.MAINHAND : (slot = pl.getItemBySlot(EquipmentSlot.OFFHAND) == stack ? EquipmentSlot.OFFHAND : null);
                        if (slot != null) {
                            pl.onEquippedItemBroken(item, slot);
                        }
                        EventHooks.onPlayerDestroyItem((Player)pl, (ItemStack)stack, (InteractionHand)(slot != null && slot.isArmor() ? null : (slot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND)));
                    });
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 2, new Component[0]));
    }
}

