/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.food;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class HealingFood
extends Item {
    private final float healingAmount;

    public HealingFood(float healAmount, Item.Properties itemProperties) {
        super(itemProperties);
        this.healingAmount = healAmount;
    }

    public float getHealAmount() {
        return this.healingAmount;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        float percentHunger = 100.0f;
        if (entity instanceof Player) {
            percentHunger = Math.min((float)(20 - ((Player)entity).getFoodData().getFoodLevel()) / (float)this.getFoodProperties(stack, entity).nutrition(), 1.0f);
        }
        ItemStack returnStack = super.finishUsingItem(stack, world, entity);
        if (entity instanceof Player) {
            EntityUtil.healEntity(entity, this.healingAmount * percentHunger);
        }
        return returnStack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.HEALING_FOOD_DESCRIPTION, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.HEALING_FOOD_AMOUNT, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.literal((String)Float.toString(this.healingAmount))}));
    }
}

