/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.food;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.EffectCures;
import net.tslat.aoa3.common.registration.item.AoAFood;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class HalyconMilk
extends Item {
    public HalyconMilk() {
        super(new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1).craftRemainder(Items.BUCKET).food(AoAFood.HALYCON_MILK));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        if (!level.isClientSide) {
            EntityUtil.healEntity(entity, 2.0f);
            entity.removeEffectsCuredBy(EffectCures.MILK);
            if (entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                for (FoodProperties.PossibleEffect effect : stack.getItem().getFoodProperties(stack, (LivingEntity)player).effects()) {
                    if (!(level.random.nextFloat() < effect.probability())) continue;
                    player.addEffect(new MobEffectInstance(effect.effect()));
                }
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        return stack.isEmpty() ? new ItemStack((ItemLike)Items.BUCKET) : stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

