/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RegistryUtil;
import org.jetbrains.annotations.Nullable;

public class SkillHelmet
extends AdventArmour {
    private final Supplier<AoASkill> skill;

    public SkillHelmet(Supplier<AoASkill> skill) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.SKILL_HELMET, ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(50)).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false)));
        this.skill = skill;
    }

    public AoASkill getSkill() {
        return this.skill.get();
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    @Override
    public boolean isCompatibleWithAnySet() {
        return true;
    }

    public boolean isEnchantable(ItemStack pStack) {
        return true;
    }

    @Override
    public void onEquip(LivingEntity entity, AdventArmour.Piece piece, EnumSet<AdventArmour.Piece> equippedPieces) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            PlayerUtil.getAdventPlayer(pl).getSkill(this.getSkill()).applyXpModifier(0.5f);
        }
    }

    @Override
    public void onUnequip(LivingEntity entity, AdventArmour.Piece piece, EnumSet<AdventArmour.Piece> equippedPieces) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            PlayerUtil.getAdventPlayer(pl).getSkill(this.getSkill()).removeXpModifier(0.5f);
        }
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return AdventOfAscension.id("textures/models/armor/custom/" + RegistryUtil.getId(stack.getItem()).getPath() + (ClientPlayerDataManager.get().getSkill(this.getSkill()).getLevel(true) == 1000 ? "_trim" : "") + ".png");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag pFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.unbreakable", LocaleUtil.ItemDescriptionType.UNIQUE, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.XP_BONUS, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[]{LocaleUtil.numToComponent(50), this.getSkill().getName()}));
        tooltip.add((Component)this.anySetEffectHeader());
    }
}

