/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class SealordHelmet
extends AdventArmour {
    public static final AttributeModifier SEALORD_ATTACK_BUFF = new AttributeModifier(AdventOfAscension.id("sealord_helmet"), 2.0, AttributeModifier.Operation.ADD_VALUE);

    public SealordHelmet() {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.SEALORD_HELMET, ArmorItem.Type.HELMET, 60);
    }

    @Override
    public boolean isCompatibleWithAnySet() {
        return true;
    }

    @Override
    public void onArmourTick(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces) {
        if (entity.isEyeInFluid(FluidTags.WATER)) {
            AttributeUtil.applyTransientModifier(entity, (Holder<Attribute>)Attributes.ATTACK_SPEED, SEALORD_ATTACK_BUFF);
        } else {
            AttributeUtil.removeModifier(entity, (Holder<Attribute>)Attributes.ATTACK_SPEED, SEALORD_ATTACK_BUFF);
        }
        if (entity.isInWater()) {
            entity.setAirSupply(-10);
        }
    }

    @Override
    public void onUnequip(LivingEntity entity, AdventArmour.Piece piece, EnumSet<AdventArmour.Piece> equippedPieces) {
        AttributeUtil.removeModifier(entity, (Holder<Attribute>)Attributes.ATTACK_SPEED, SEALORD_ATTACK_BUFF);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.ARMOUR_AIRTIGHT, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add((Component)this.anySetEffectHeader());
    }
}

