/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class KnightArmour
extends AdventArmour {
    public static final AttributeModifier KNIGHT_BOOTS_BUFF = new AttributeModifier(AdventOfAscension.id("knight_armour_boots"), 5.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier KNIGHT_LEGS_BUFF = new AttributeModifier(AdventOfAscension.id("knight_armour_leggings"), 5.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier KNIGHT_CHESTPLATE_BUFF = new AttributeModifier(AdventOfAscension.id("knight_armour_chestplate"), 5.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier KNIGHT_HELMET_BUFF = new AttributeModifier(AdventOfAscension.id("knight_armour_helmet"), 5.0, AttributeModifier.Operation.ADD_VALUE);

    public KnightArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.KNIGHT, slot, 70);
    }

    @Override
    public void addArmourAttributes(EquipmentSlotGroup slot, BiConsumer<Holder<Attribute>, AttributeModifier> attributes) {
        EquipmentSlotGroup equipmentSlotGroup = slot;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FEET", "LEGS", "CHEST", "HEAD"}, (EquipmentSlotGroup)equipmentSlotGroup, n)) {
            case 0: {
                attributes.accept((Holder<Attribute>)Attributes.MAX_HEALTH, KNIGHT_BOOTS_BUFF);
                break;
            }
            case 1: {
                attributes.accept((Holder<Attribute>)Attributes.MAX_HEALTH, KNIGHT_LEGS_BUFF);
                break;
            }
            case 2: {
                attributes.accept((Holder<Attribute>)Attributes.MAX_HEALTH, KNIGHT_CHESTPLATE_BUFF);
                break;
            }
            case 3: {
                attributes.accept((Holder<Attribute>)Attributes.MAX_HEALTH, KNIGHT_HELMET_BUFF);
                break;
            }
        }
    }

    @Override
    public void onArmourTick(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces) {
        if (equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET) && entity.isAlive() && EntityUtil.getHealthPercent(entity) < 0.2f) {
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 2, 1, false, true));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.knight_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

