/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class BattlebornArmour
extends AdventArmour {
    private static final ResourceLocation ATTACK_SPEED_MODIFIER = AdventOfAscension.id("battleborn_armor");

    public BattlebornArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.BATTLEBORN, slot, 65);
    }

    private static AttributeModifier createModifier(int cooldownTicks) {
        return new AttributeModifier(ATTACK_SPEED_MODIFIER, Math.min(0.65, (double)cooldownTicks / 240.0), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    @Override
    public void handleOutgoingAttack(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingIncomingDamageEvent ev) {
        if (DamageUtil.isMeleeDamage(ev.getSource()) && entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            int counter = this.getArmourCooldown((Player)pl);
            int newAmount = Math.min(300, counter + this.perPieceValue(equippedPieces, 6));
            this.setArmourCooldown((Player)pl, AoAArmour.BATTLEBORN_ARMOUR, newAmount);
            AttributeUtil.applyTransientModifier(entity, (Holder<Attribute>)Attributes.ATTACK_SPEED, BattlebornArmour.createModifier(newAmount));
        }
    }

    @Override
    public void onArmourTick(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces) {
        Player pl;
        int counter;
        if (entity instanceof Player && (counter = this.getArmourCooldown(pl = (Player)entity)) > 0) {
            if (counter == 1) {
                AttributeUtil.removeModifier(entity, (Holder<Attribute>)Attributes.ATTACK_SPEED, ATTACK_SPEED_MODIFIER);
            } else if (entity.level().getGameTime() % 10L == 0L) {
                AttributeUtil.applyTransientModifier(entity, (Holder<Attribute>)Attributes.ATTACK_SPEED, BattlebornArmour.createModifier(counter));
            }
        }
    }

    @Override
    public void onUnequip(LivingEntity entity, AdventArmour.Piece piece, EnumSet<AdventArmour.Piece> equippedPieces) {
        Player pl;
        int cooldown;
        if (equippedPieces.size() == 1 && entity instanceof Player && (cooldown = this.getArmourCooldown(pl = (Player)entity)) > 0) {
            AttributeUtil.removeModifier(entity, (Holder<Attribute>)Attributes.ATTACK_SPEED, ATTACK_SPEED_MODIFIER);
            this.setArmourCooldown(pl, AoAArmour.BATTLEBORN_ARMOUR, (int)((float)cooldown * 0.75f));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.battleborn_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.battleborn_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

