/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class ArchaicArmour
extends AdventArmour {
    public ArchaicArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.ARCHAIC, slot, 67);
    }

    @Override
    public void handleOutgoingAttack(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingIncomingDamageEvent ev) {
        if (DamageUtil.isMeleeDamage(ev.getSource())) {
            ev.setAmount(ev.getAmount() * (1.0f + this.perPieceValue(equippedPieces, 0.1875f) * (1.0f - EntityUtil.getHealthPercent(entity))));
        }
    }

    @Override
    public void handleIncomingDamage(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingIncomingDamageEvent ev) {
        if (!equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET)) {
            ev.setAmount(ev.getAmount() * (1.0f + this.perPieceValue(equippedPieces, 0.16f) * (1.0f - EntityUtil.getHealthPercent(entity))));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.archaic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.archaic_armour.desc.2", LocaleUtil.ItemDescriptionType.HARMFUL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.archaic_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

