/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public interface LootModifyingItem {
    public void doLootModification(List<ItemStack> var1, LootContext var2);

    default public boolean isBlockHarvestLoot(LootContext context) {
        for (LootContextParam param : LootContextParamSets.BLOCK.getRequired()) {
            if (context.hasParam(param)) continue;
            return false;
        }
        return true;
    }

    default public boolean isEntityKillLoot(LootContext context) {
        for (LootContextParam param : LootContextParamSets.ENTITY.getRequired()) {
            if (context.hasParam(param)) continue;
            return false;
        }
        return true;
    }

    default public boolean isFishingLoot(LootContext context) {
        for (LootContextParam param : LootContextParamSets.FISHING.getRequired()) {
            if (context.hasParam(param)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public BlockState getHarvestedBlock(LootContext lootContext) {
        if (!this.isBlockHarvestLoot(lootContext)) {
            return Blocks.AIR.defaultBlockState();
        }
        return (BlockState)lootContext.getParamOrNull(LootContextParams.BLOCK_STATE);
    }

    default public ItemStack getToolStack(LootContext lootContext) {
        return (ItemStack)lootContext.getParamOrNull(LootContextParams.TOOL);
    }
}

