/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item;

import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.tslat.aoa3.common.registration.item.AoADataComponents;

public interface ChargeableItem {
    default public float minRequiredCharge() {
        return 0.0f;
    }

    default public float maxCharge() {
        return Float.MAX_VALUE;
    }

    default public boolean hasEnoughCharge(ItemStack stack) {
        return this.getCharge(stack) >= this.minRequiredCharge();
    }

    default public float getCharge(ItemStack stack) {
        return ((Float)stack.getOrDefault(AoADataComponents.CHARGE, (Object)Float.valueOf(0.0f))).floatValue();
    }

    default public void setCharge(ItemStack stack, float charge) {
        stack.set(AoADataComponents.CHARGE, (Object)Float.valueOf(Mth.clamp((float)charge, (float)0.0f, (float)this.maxCharge())));
    }

    default public void addCharge(ItemStack stack, float charge) {
        stack.set(AoADataComponents.CHARGE, (Object)Float.valueOf(Math.min(this.getCharge(stack) + charge, this.maxCharge())));
    }

    default public float subtractCharge(ItemStack stack, float subtraction, boolean force) {
        float currentCharge = this.getCharge(stack);
        if (currentCharge < subtraction && !force) {
            return 0.0f;
        }
        float newValue = Math.max(0.0f, currentCharge - subtraction);
        this.setCharge(stack, newValue);
        return currentCharge - newValue;
    }
}

