/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.thrown;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.content.item.weapon.thrown.SliceStar;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.RandomUtil;

public class SliceStarEntity
extends BaseBullet
implements HardProjectile,
ItemSupplier {
    public SliceStarEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public SliceStarEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.SLICE_STAR.get()), world);
    }

    public SliceStarEntity(LivingEntity shooter, BaseGun gun) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.SLICE_STAR.get()), shooter, gun, 1.0f, 0, 3.0f);
    }

    public SliceStarEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.SLICE_STAR.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public SliceStarEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.SLICE_STAR.get()), world, x, y, z);
    }

    @Override
    public double getDefaultGravity() {
        return 0.05f;
    }

    @Override
    public void doEntityImpact(Entity target, Vec3 impactLocation) {
        if (DamageUtil.doProjectileAttack(this.getOwner(), (Entity)this, target, ((SliceStar)((Object)AoAWeapons.SLICE_STAR.get())).getGunDamage(this.getWeaponStack(AoAWeapons.SLICE_STAR.asItem()))) && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (RandomUtil.oneInNChance((int)10)) {
                livingEntity.addEffect(new EffectBuilder(AoAMobEffects.BLEEDING, 80).hideParticles().build());
            }
        }
    }

    @Override
    protected void onHit(HitResult result) {
        if (result instanceof BlockHitResult && this.tickCount <= 1 && this.getOwner() == null) {
            return;
        }
        super.onHit(result);
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)AoAWeapons.SLICE_STAR.get());
    }
}

