/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.thrown;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.misc.HellfireProjectileEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;

public class HellfireEntity
extends BaseBullet
implements HardProjectile,
ItemSupplier {
    private LivingEntity shooter;

    public HellfireEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public HellfireEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELLFIRE.get()), world);
    }

    public HellfireEntity(LivingEntity shooter, BaseGun gun) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELLFIRE.get()), shooter, gun, 1.0f, 0, 1.5f);
        this.shooter = shooter;
    }

    public HellfireEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELLFIRE.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public HellfireEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELLFIRE.get()), world, x, y, z);
    }

    @Override
    public double getDefaultGravity() {
        return 0.075f;
    }

    @Override
    protected void onHit(HitResult result) {
        if (result instanceof BlockHitResult && this.tickCount <= 1 && this.getOwner() == null) {
            return;
        }
        super.onHit(result);
    }

    @Override
    public void doBlockImpact(Vec3 impactLocation, Direction face, BlockPos blockPos) {
        this.explode(impactLocation);
    }

    @Override
    public void doEntityImpact(Entity target, Vec3 impactLocation) {
        this.explode(impactLocation);
    }

    protected void explode(Vec3 position) {
        Player pl;
        int count = 0;
        Entity entity = this.getOwner();
        Player attacker = entity instanceof Player ? (pl = (Player)entity) : null;
        for (LivingEntity target : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(7.0), EntityUtil::isHostileMob)) {
            if (!DamageUtil.doMiscMagicAttack(this.getOwner(), (Entity)target, 3.5f, this.position())) continue;
            HellfireProjectileEntity tail = new HellfireProjectileEntity(this, target.getX(), target.getY(), target.getZ());
            tail.setOwner(this.getOwner());
            this.level().addFreshEntity((Entity)tail);
            target.igniteForSeconds(10.0f);
            target.hurt(this.level().damageSources().indirectMagic((Entity)attacker, (Entity)this), 0.1f);
            if (attacker != null) {
                target.setLastHurtByMob((LivingEntity)attacker);
                target.setLastHurtByPlayer(attacker);
            }
            ++count;
        }
        if (this.shooter instanceof Player) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)AoASounds.HELLFIRE_IMPACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (count >= 20 && this.shooter instanceof ServerPlayer) {
                AdvancementUtil.grantCriterion((ServerPlayer)this.shooter, AdventOfAscension.id("overworld/heckfire"), "20_target_hellfire");
            }
        }
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)AoAWeapons.HELLFIRE.get());
    }
}

