/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.thrown;

import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.content.item.weapon.thrown.HardenedParapiranha;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HardenedParapiranhaEntity
extends BaseBullet
implements HardProjectile,
GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HardenedParapiranhaEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public HardenedParapiranhaEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HARDENED_PARAPIRANHA.get()), world);
    }

    public HardenedParapiranhaEntity(LivingEntity shooter, BaseGun gun) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HARDENED_PARAPIRANHA.get()), shooter, gun, 1.0f, 0, 1.5f);
    }

    public HardenedParapiranhaEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HARDENED_PARAPIRANHA.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public HardenedParapiranhaEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HARDENED_PARAPIRANHA.get()), world, x, y, z);
    }

    @Override
    public double getDefaultGravity() {
        return 0.1f;
    }

    @Override
    public void tick() {
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        double motionVector = Math.sqrt(motion.x() * motion.x() + motion.z() * motion.z());
        this.setYRot((float)(Mth.atan2((double)motion.x(), (double)motion.z()) * 57.29577951308232));
        this.setXRot((float)(Mth.atan2((double)motion.y(), (double)motionVector) * 57.29577951308232));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    @Override
    protected void onHit(HitResult result) {
        if (result instanceof BlockHitResult && this.tickCount <= 1 && this.getOwner() == null) {
            return;
        }
        super.onHit(result);
    }

    @Override
    public void doEntityImpact(Entity target, Vec3 impactLocation) {
        if (DamageUtil.doProjectileAttack(this.getOwner(), (Entity)this, target, ((HardenedParapiranha)((Object)AoAWeapons.HARDENED_PARAPIRANHA.get())).getGunDamage(this.getWeaponStack(AoAWeapons.HARDENED_PARAPIRANHA.asItem())))) {
            EntityUtil.applyPotions(target, new EffectBuilder(MobEffects.WITHER, 60).level(2));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericFlyController((GeoAnimatable)this));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

