/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.thrown;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.object.explosion.ShrapnelExplosion;
import net.tslat.aoa3.util.AdvancementUtil;

public class GrenadeEntity
extends BaseBullet
implements HardProjectile {
    public GrenadeEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public GrenadeEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.GRENADE.get()), world);
    }

    public GrenadeEntity(LivingEntity shooter, BaseGun gun) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.GRENADE.get()), shooter, gun, 1.0f, 0, 1.5f);
    }

    public GrenadeEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.GRENADE.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public GrenadeEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.GRENADE.get()), world, x, y, z);
    }

    @Override
    public double getDefaultGravity() {
        return 0.075f;
    }

    @Override
    protected void onHit(HitResult result) {
        if (result instanceof BlockHitResult && this.tickCount <= 1 && this.getOwner() == null) {
            return;
        }
        super.onHit(result);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.IS_FIRE)) {
            this.explode(this.position());
            Entity entity = this.getOwner();
            if (entity instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)entity;
                AdvancementUtil.grantCriterion(pl, AdventOfAscension.id("completionist/darwin_award"), "fire_grenade");
            }
            this.discard();
            return true;
        }
        return super.hurt(source, amount);
    }

    @Override
    public void doBlockImpact(Vec3 impactLocation, Direction face, BlockPos blockPos) {
        this.explode(impactLocation);
    }

    @Override
    public void doEntityImpact(Entity target, Vec3 impactLocation) {
        this.explode(impactLocation);
    }

    protected void explode(Vec3 position) {
        if (!this.level().isClientSide()) {
            new ShrapnelExplosion(AoAExplosions.GRENADE, (ServerLevel)this.level(), (Entity)this, this.getOwner(), position).explode();
        }
    }
}

