/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.staff;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.WorldUtil;

public class SunShotEntity
extends BaseEnergyShot {
    public SunShotEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public SunShotEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.SUN_SHOT.get()), world);
    }

    public SunShotEntity(LivingEntity shooter, EnergyProjectileWeapon weapon, int maxAge) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.SUN_SHOT.get()), shooter, weapon, maxAge);
    }

    public SunShotEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.SUN_SHOT.get()), world, x, y, z);
    }

    @Override
    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.3, 0.3));
        for (LivingEntity e : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(10.0), EntityUtil::isHostileMob)) {
            if (e.isOnFire() || e.fireImmune()) continue;
            e.igniteForSeconds(2.0f);
        }
        if (this.getAge() >= 260) {
            WorldUtil.createExplosion(this.getOwner(), this.level(), (Entity)this, 3.5f);
            this.discard();
        }
    }

    @Override
    protected void onHit(HitResult result) {
        this.setDeltaMovement(new Vec3(0.0, this.level().getBlockState(this.blockPosition().below()).getBlock() != Blocks.AIR ? 1.0 : this.getDeltaMovement().y(), 0.0));
    }
}

