/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.staff;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;

public class RosidianShotEntity
extends BaseEnergyShot {
    private boolean impacted = false;

    public RosidianShotEntity(RosidianShotEntity tangleShot, double posX, double posY, double posZ) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.ROSIDIAN_SHOT.get()), tangleShot.getOwner(), tangleShot.weapon, posX, posY, posZ, -1.0f);
        this.lifespan = 2;
    }

    public RosidianShotEntity(LivingEntity shooter, EnergyProjectileWeapon weapon) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.PRIMORDIAL_SHOT.get()), shooter, weapon, 180);
    }

    public RosidianShotEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.PRIMORDIAL_SHOT.get()), world, x, y, z);
    }

    public RosidianShotEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public RosidianShotEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.PRIMORDIAL_SHOT.get()), world);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.impacted && this.lifespan > 15 && this.tickCount % 5 == 0) {
            double posX = this.getX() + this.random.nextGaussian() * 3.0;
            double posZ = this.getZ() + this.random.nextGaussian() * 3.0;
            double posY = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, BlockPos.containing((double)posX, (double)this.getY(), (double)posZ)).getY();
            this.level().addFreshEntity((Entity)new RosidianShotEntity(this, posX, posY + 0.5, posZ));
        }
    }

    @Override
    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            super.onHit(result);
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.impacted = true;
        }
    }
}

