/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.mob;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.FireballEntity;
import net.tslat.aoa3.library.object.explosion.StandardExplosion;
import net.tslat.effectslib.api.particle.ParticleBuilder;

public class StickyFireballEntity
extends FireballEntity {
    public StickyFireballEntity(EntityType<? extends StickyFireballEntity> entityType, Level level) {
        super((EntityType<? extends FireballEntity>)entityType, level);
    }

    public StickyFireballEntity(Level world, AoARangedAttacker shooter, BaseMobProjectile.Type projectileType) {
        super((EntityType<? extends FireballEntity>)((EntityType)AoAProjectiles.STICKY_FIREBALL.get()), world, shooter, projectileType);
    }

    @Override
    public double getDefaultGravity() {
        return 0.1f;
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.tickCount == 99) {
                new StandardExplosion(AoAExplosions.STICKY_FIREBALL, serverLevel, (Entity)this, this.getOwner(), this.position()).explode();
                this.discard();
                return;
            }
        }
        if (this.onGround()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        if (this.level().isClientSide() && (this.getDeltaMovement().lengthSqr() != 0.0 || this.tickCount % 4 == 0)) {
            ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (Entity)this).lifespan(40).scaleMod(0.5f).spawnParticles(this.level());
        }
    }

    @Override
    protected void onHit(HitResult result) {
        if (result.getType() != HitResult.Type.BLOCK || this.level().getBlockState(BlockPos.containing((Position)result.getLocation())).blocksMotion()) {
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                if (this.level().isClientSide || entityHitResult.getEntity() == this.shooter || this.shooter == null) {
                    return;
                }
                this.onHitEntity(entityHitResult);
                this.shooter.doRangedAttackEntity(this, entityHitResult.getEntity());
                this.discard();
            } else if (result instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)result;
                if (this.getDeltaMovement().y > 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, (double)-0.05f, 1.0));
                    return;
                }
                if (!this.level().isClientSide && this.shooter != null & this.getDeltaMovement().lengthSqr() != 0.0) {
                    this.onHitBlock(blockHitResult);
                    this.shooter.doRangedAttackBlock(this, this.level().getBlockState(BlockPos.containing((Position)result.getLocation())), BlockPos.containing((Position)result.getLocation()), blockHitResult.getDirection());
                }
                if (!this.onGround()) {
                    this.setPos(blockHitResult.getLocation().subtract(this.getDeltaMovement().multiply(0.25, 0.25, 0.25)));
                    this.setDeltaMovement(0.0, 0.0, 0.0);
                    this.setOnGround(true);
                }
            }
        }
    }
}

