/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.misc;

import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.WorldUtil;

public class SelyanSticklerStuckEntity
extends ThrowableProjectile {
    private LivingEntity target;
    private LivingEntity shooter;
    private int age;

    public SelyanSticklerStuckEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public SelyanSticklerStuckEntity(Level world) {
        super((EntityType)AoAProjectiles.SELYAN_STICKLER_STUCK.get(), world);
    }

    public SelyanSticklerStuckEntity(LivingEntity shooter, BaseGun gun, LivingEntity target, float bulletDmgMultiplier) {
        super((EntityType)AoAProjectiles.SELYAN_STICKLER_STUCK.get(), shooter.level());
        this.target = target;
        this.shooter = shooter;
        this.moveTo(target.getX(), target.getY() + (double)target.getEyeHeight(), target.getZ(), 0.0f, 0.0f);
        this.shoot(0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    public SelyanSticklerStuckEntity(Level world, double x, double y, double z) {
        super((EntityType)AoAProjectiles.SELYAN_STICKLER_STUCK.get(), x, y, z, world);
    }

    public double getDefaultGravity() {
        return 0.0;
    }

    protected void onHit(HitResult result) {
    }

    public void tick() {
        super.tick();
        ++this.age;
        if (this.level().isClientSide) {
            return;
        }
        if (this.target != null && this.target.isAlive()) {
            this.moveTo(this.target.getX(), this.target.getY() + (double)this.target.getEyeHeight(), this.target.getZ(), 0.0f, 360.0f);
            EntityUtil.healEntity(this.shooter, 0.03f);
        } else {
            WorldUtil.createExplosion(this.getOwner(), this.level(), (Entity)this, 2.0f);
            if (!this.level().isClientSide) {
                this.discard();
            }
        }
        if (this.age >= 100) {
            WorldUtil.createExplosion(this.getOwner(), this.level(), this.getX(), this.getY() + 1.0, this.getZ(), 2.0f);
            if (!this.level().isClientSide) {
                this.discard();
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

