/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.misc;

import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.WorldUtil;

public class PlutonSticklerStuckEntity
extends ThrowableProjectile {
    private LivingEntity target;
    private LivingEntity shooter;
    private int age;

    public PlutonSticklerStuckEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public PlutonSticklerStuckEntity(Level world) {
        super((EntityType)AoAProjectiles.PLUTON_STICKLER_STUCK.get(), world);
    }

    public PlutonSticklerStuckEntity(LivingEntity shooter, BaseGun gun, LivingEntity target, float bulletDmgMultiplier) {
        super((EntityType)AoAProjectiles.PLUTON_STICKLER_STUCK.get(), shooter.level());
        this.target = target;
        this.shooter = shooter;
        this.moveTo(target.getX(), target.getY() + (double)target.getEyeHeight(), target.getZ(), 0.0f, 0.0f);
        this.shoot(0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    public PlutonSticklerStuckEntity(Level world, double x, double y, double z) {
        super((EntityType)AoAProjectiles.PLUTON_STICKLER_STUCK.get(), x, y, z, world);
    }

    public double getDefaultGravity() {
        return 0.0;
    }

    protected void onHit(HitResult result) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        ++this.age;
        if (this.level().isClientSide) {
            return;
        }
        if (this.target != null && this.target.isAlive()) {
            this.moveTo(this.target.getX(), this.target.getY() + (double)this.target.getEyeHeight(), this.target.getZ(), 0.0f, 360.0f);
        } else {
            WorldUtil.createExplosion((Entity)this.shooter, this.level(), (Entity)this, 2.0f);
            this.explodeCoins();
            if (!this.level().isClientSide) {
                this.discard();
            }
        }
        if (this.age >= 100) {
            WorldUtil.createExplosion((Entity)this.shooter, this.level(), this.getX(), this.getY() + 1.0, this.getZ(), 2.0f);
            this.explodeCoins();
            if (!this.level().isClientSide) {
                this.discard();
            }
        }
    }

    private void explodeCoins() {
        for (float x = -0.5f; x <= 0.5f; x += 0.5f) {
            for (float y = -0.5f; y <= 0.5f; y += 0.5f) {
                for (float z = -0.5f; z <= 0.5f; z += 0.5f) {
                    ItemEntity coin = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)AoAItems.COPPER_COIN.get()));
                    coin.setPickUpDelay(120);
                    coin.push((double)x, (double)y, (double)z);
                    coin.lifespan = 140;
                    this.level().addFreshEntity((Entity)coin);
                }
            }
        }
    }
}

