/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.gun;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.content.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.content.item.weapon.thrown.BaseThrownWeapon;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class BaseBullet
extends ThrowableProjectile
implements HardProjectile {
    private float dmgMulti;
    private int lifespan;
    private int pierceCount;
    private int age = 0;
    private BaseGun weapon;
    private Entity lastPierceTarget;
    private InteractionHand hand;
    private Entity cachedOwner = null;

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, BaseGun gun, float dmgMultiplier, int piercingValue, float velocity) {
        super(entityType, shooter.level());
        this.dmgMulti = dmgMultiplier;
        this.lifespan = 60;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = InteractionHand.MAIN_HAND;
        this.setOwner((Entity)shooter);
        this.moveTo(shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight(), shooter.getZ(), shooter.getYRot(), shooter.getXRot());
        Vec3 velocityVector = EntityUtil.getVelocityVectorForFacing((Entity)this);
        this.shoot(velocityVector.x(), velocityVector.y(), velocityVector.z(), velocity, 0.0f);
    }

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, float dmgMultiplier, int piercingValue, float xMod, float yMod, float zMod) {
        super(entityType, shooter.level());
        this.dmgMulti = dmgMultiplier;
        this.lifespan = maxAge;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = hand;
        this.moveTo(shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight(), shooter.getZ(), shooter.getYRot(), shooter.getXRot());
        boolean right = true;
        if (shooter instanceof Player) {
            if (hand == InteractionHand.MAIN_HAND) {
                if (shooter.getMainArm() == HumanoidArm.LEFT) {
                    right = false;
                }
            } else if (shooter.getMainArm() == HumanoidArm.RIGHT) {
                right = false;
            }
        }
        this.setOwner((Entity)shooter);
        this.shoot(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))) + xMod, -Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180))) + yMod, Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))) + zMod, 3.0f, 2.0f);
        if (right) {
            this.setPos(this.getDeltaMovement().x() * 0.5 + this.getX() - (double)(Mth.cos((float)(this.getYRot() / 57.295776f)) * 0.4f), this.getDeltaMovement().y() * 0.5 + this.getY() - 0.3, this.getDeltaMovement().z() * 0.5 + this.getZ() + (double)(Mth.sin((float)(this.getYRot() / 57.295776f)) * 0.4f));
        } else {
            this.setPos(this.getDeltaMovement().x() * 0.5 + this.getX() + (double)(Mth.cos((float)(this.getYRot() / 57.295776f)) * 0.4f), this.getDeltaMovement().y() * 0.5 + this.getY() - 0.3, this.getDeltaMovement().z() * 0.5 + this.getZ() - (double)(Mth.sin((float)(this.getYRot() / 57.295776f)) * 0.4f));
        }
    }

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, float dmgMultiplier, int piercingValue) {
        super(entityType, shooter.level());
        boolean right;
        this.dmgMulti = dmgMultiplier;
        this.lifespan = maxAge;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = hand;
        this.setOwner((Entity)shooter);
        this.moveTo(shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight(), shooter.getZ(), shooter.getYRot(), shooter.getXRot());
        boolean bl = right = shooter.getMainArm() == HumanoidArm.RIGHT;
        if (shooter instanceof Player) {
            if (hand == InteractionHand.MAIN_HAND) {
                if (shooter.getMainArm() == HumanoidArm.LEFT) {
                    right = false;
                }
            } else if (shooter.getMainArm() == HumanoidArm.RIGHT) {
                right = false;
            }
        }
        this.shoot(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), -Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), 3.0f, 0.0f);
        if (right) {
            this.setPos(this.getDeltaMovement().x() * 0.5 + this.getX() - (double)(Mth.cos((float)(this.getYRot() / 57.295776f)) * 0.4f), this.getDeltaMovement().y() * 0.5 + this.getY() - 0.3, this.getDeltaMovement().z() * 0.5 + this.getZ() + (double)(Mth.sin((float)(this.getYRot() / 57.295776f)) * 0.4f));
        } else {
            this.setPos(this.getDeltaMovement().x() * 0.5 + this.getX() + (double)(Mth.cos((float)(this.getYRot() / 57.295776f)) * 0.4f), this.getDeltaMovement().y() * 0.5 + this.getY() - 0.3, this.getDeltaMovement().z() * 0.5 + this.getZ() - (double)(Mth.sin((float)(this.getYRot() / 57.295776f)) * 0.4f));
        }
    }

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, Level world, double x, double y, double z) {
        super(entityType, world);
        this.lifespan = 60;
        this.setPos(x, y, z);
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && this.cachedOwner.isAlive()) {
            return this.cachedOwner;
        }
        this.cachedOwner = super.getOwner();
        return this.cachedOwner;
    }

    public void shoot(double directionX, double directionY, double directionZ, float velocity, float inaccuracy) {
        Vec3 motionVec = new Vec3(directionX, directionY, directionZ).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(motionVec);
        double lat = motionVec.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)motionVec.x, (double)motionVec.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)motionVec.y, (double)lat) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.hasImpulse = true;
    }

    protected void onHitBlock(BlockHitResult rayTrace) {
        float hardness;
        BlockPos resultPos = rayTrace.getBlockPos();
        BlockState block = this.level().getBlockState(resultPos);
        if (!this.level().isClientSide) {
            TELParticlePacket packet = new TELParticlePacket(5);
            for (int i = 0; i < 5; ++i) {
                packet.particle(ParticleBuilder.forPositions((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), (Vec3[])new Vec3[]{rayTrace.getLocation()}).scaleMod((float)RandomUtil.randomValueBetween((double)0.5, (double)0.75)).cutoffDistance(64.0));
            }
            packet.sendToAllPlayersTrackingEntity((ServerLevel)this.level(), (Entity)this);
        }
        block.onProjectileHit(this.level(), block, rayTrace, (Projectile)this);
        if (AoAGameRules.checkDestructiveWeaponPhysics(this.level()) && (hardness = block.getDestroySpeed((BlockGetter)this.level(), resultPos)) >= 0.0f && hardness <= 0.3f) {
            if (this.random.nextBoolean()) {
                this.level().destroyBlock(resultPos, true);
            } else {
                this.level().setBlockAndUpdate(resultPos, Blocks.AIR.defaultBlockState());
            }
            if (this.random.nextFloat() > hardness / 1.5f) {
                return;
            }
        }
        if (!block.blocksMotion()) {
            return;
        }
        this.doBlockImpact(rayTrace.getLocation(), rayTrace.getDirection(), rayTrace.getBlockPos());
        this.discard();
    }

    protected void onHitEntity(EntityHitResult rayTrace) {
        Entity entityResult = rayTrace.getEntity();
        if (entityResult != this.lastPierceTarget) {
            Entity entity;
            if (this.weapon != null && (entity = this.getOwner()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                this.weapon.doImpactDamage(entityResult, owner, this, rayTrace.getLocation(), this.dmgMulti);
            }
            this.doEntityImpact(entityResult, rayTrace.getLocation());
            --this.pierceCount;
        }
        if (this.pierceCount >= 0) {
            this.lastPierceTarget = entityResult;
            return;
        }
        this.discard();
    }

    protected void onHit(HitResult result) {
        if (this.level().isClientSide || result.getType() == HitResult.Type.MISS || !this.isAlive()) {
            return;
        }
        if (result.getType() == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)result);
        } else {
            this.onHitEntity((EntityHitResult)result);
        }
    }

    public void doEntityImpact(Entity target, Vec3 impactLocation) {
    }

    @Override
    public void doBlockImpact(Vec3 impactLocation, Direction face, BlockPos blockPos) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        AABB boundingBox;
        Vec3 position;
        if (!this.isAlive()) {
            return;
        }
        Vec3 motion = this.getDeltaMovement();
        if (this.tickCount == 1 && !(this.weapon instanceof BaseThrownWeapon)) {
            float mod = this.weapon instanceof BaseSniper ? 0.05f : 0.5f;
            position = new Vec3(this.getX() - motion.x() * (double)mod, this.getY() - motion.y() * (double)mod, this.getZ() - motion.z() * (double)mod);
            boundingBox = new AABB(position.x(), position.y(), position.z(), this.getX(), this.getY(), this.getZ());
        } else {
            boundingBox = this.getBoundingBox();
            position = new Vec3(this.getX(), this.getY(), this.getZ());
        }
        Vec3 velocityAdjustedPosition = new Vec3(this.getX() + motion.x(), this.getY() + motion.y(), this.getZ() + motion.z());
        BlockHitResult intersectedBlocksTrace = this.level().clip(new ClipContext(position, velocityAdjustedPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        velocityAdjustedPosition = intersectedBlocksTrace.getType() != HitResult.Type.MISS ? new Vec3(intersectedBlocksTrace.getLocation().x, intersectedBlocksTrace.getLocation().y, intersectedBlocksTrace.getLocation().z) : new Vec3(this.getX() + motion.x(), this.getY() + motion.y(), this.getZ() + motion.z());
        Entity shooter = this.getOwner();
        EntityHitResult entityTrace = EntityUtil.getEntityCollisionWithPrecision(this.level(), (Entity)this, position, velocityAdjustedPosition, boundingBox.expandTowards(motion.x(), motion.y(), motion.z()).inflate(0.1), entity -> entity.isAlive() && entity.isPickable() && !entity.isSpectator() && entity != shooter, 0.3f);
        if (entityTrace != null) {
            intersectedBlocksTrace = entityTrace;
        }
        if (intersectedBlocksTrace.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)intersectedBlocksTrace)) {
            this.onHit((HitResult)intersectedBlocksTrace);
        }
        if (!this.isAlive()) {
            return;
        }
        this.xOld = this.getX();
        this.yOld = this.getY();
        this.zOld = this.getZ();
        super.tick();
        if (!this.level().isClientSide) {
            if (this.age > this.lifespan) {
                this.discard();
            } else {
                ++this.age;
            }
        }
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public BaseBullet setMaxAge(int maxAge) {
        this.lifespan = maxAge;
        return this;
    }

    public BaseBullet setPierceCount(int pierceCount) {
        this.pierceCount = pierceCount;
        return this;
    }

    public int getAge() {
        return this.age;
    }

    @Nullable
    public BaseGun getWeapon() {
        return this.weapon;
    }

    public ItemStack getWeaponStack(Item fallback) {
        Entity entity;
        if (this.getWeapon() == null || !((entity = this.getOwner()) instanceof LivingEntity)) {
            return fallback.getDefaultInstance();
        }
        LivingEntity owner = (LivingEntity)entity;
        ItemStack heldStack = owner.getItemInHand(this.getHand());
        if (heldStack.is((Item)this.getWeapon())) {
            return heldStack;
        }
        return fallback.getDefaultInstance();
    }
}

