/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.arrow;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;

public class PopShotEntity
extends CustomArrowEntity {
    public final boolean isExplosive;

    public PopShotEntity(EntityType<? extends Arrow> entityType, Level world) {
        super(entityType, world);
        this.isExplosive = true;
    }

    public PopShotEntity(Level world) {
        super((EntityType<? extends Arrow>)((EntityType)AoAProjectiles.POP_SHOT.get()), world);
        this.isExplosive = true;
    }

    public PopShotEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends Arrow>)((EntityType)AoAProjectiles.POP_SHOT.get()), world);
        this.isExplosive = true;
        this.setPos(x, y, z);
    }

    public PopShotEntity(Level world, ItemStack weaponStack, LivingEntity shooter, double baseDamage, boolean isExplosive) {
        super((EntityType<? extends Arrow>)((EntityType)AoAProjectiles.POP_SHOT.get()), world);
        this.setOwner((Entity)shooter);
        this.setBaseDamage(baseDamage);
        this.setPos(shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
        this.firedFromWeapon = weaponStack;
        this.isExplosive = isExplosive;
    }

    protected void doPostHurtEffects(LivingEntity target) {
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)AoAItems.POP_SHOT.get());
    }
}

