/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.npc.trader;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.ai.trader.TraderFaceCustomerGoal;
import net.tslat.aoa3.content.entity.ai.trader.TraderPlayerTradeGoal;
import net.tslat.aoa3.content.entity.ai.trader.TraderRestockGoal;
import net.tslat.aoa3.content.entity.base.AoATrader;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SkillMasterEntity
extends AoATrader {
    private static final EntityDataAccessor<Boolean> TRADING = SynchedEntityData.defineId(SkillMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean trading = false;
    private static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES = new AoATrader.TradeListBuilder().trades(1, AoATrader.BuildableTrade.forItem(AoAItems.SMALL_SKILL_CRYSTAL).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 11).xp(20).stock(32), AoATrader.BuildableTrade.forItem(AoAItems.MEDIUM_SKILL_CRYSTAL).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 13).xp(50).stock(24), AoATrader.BuildableTrade.forItem(AoAItems.LARGE_SKILL_CRYSTAL).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 18).xp(75).stock(16), AoATrader.BuildableTrade.forItem(AoAItems.GIANT_SKILL_CRYSTAL).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 32).xp(125).stock(12), AoATrader.BuildableTrade.forItem(AoAArmour.HELM_OF_THE_DEXTROUS).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 64).xp(200).stock(Integer.MAX_VALUE), AoATrader.BuildableTrade.forItem(AoAArmour.HELM_OF_THE_DRYAD).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 64).xp(200).stock(Integer.MAX_VALUE), AoATrader.BuildableTrade.forItem(AoAArmour.HELM_OF_THE_RITUALIST).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 64).xp(200).stock(Integer.MAX_VALUE), AoATrader.BuildableTrade.forItem(AoAArmour.HELM_OF_THE_TRAWLER).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 64).xp(200).stock(Integer.MAX_VALUE), AoATrader.BuildableTrade.forItem(AoAArmour.HELM_OF_THE_TREASURER).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 64).xp(200).stock(Integer.MAX_VALUE), AoATrader.BuildableTrade.forItem(AoAArmour.HELM_OF_THE_WARRIOR).itemCost((ItemLike)AoAItems.ARCHAIC_TOKEN, 64).xp(200).stock(Integer.MAX_VALUE)).build();

    public SkillMasterEntity(EntityType<? extends AoATrader> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal<Monster>((PathfinderMob)this, Monster.class, 8.0f, 0.8, 1.2){

            public boolean canUse() {
                return !WorldUtil.isWorld(SkillMasterEntity.this.level(), AoADimensions.NOWHERE) && super.canUse();
            }
        });
        this.goalSelector.addGoal(1, (Goal)new TraderPlayerTradeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new TraderFaceCustomerGoal(this));
        this.goalSelector.addGoal(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new TraderRestockGoal(this));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5){

            public boolean canUse() {
                return !WorldUtil.isWorld(SkillMasterEntity.this.level(), AoADimensions.NOWHERE) && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TRADING, (Object)false);
    }

    @Override
    public int getMaxTradesToUnlock(int newProfessionLevel) {
        return 50;
    }

    @Override
    @Nullable
    public Int2ObjectMap<VillagerTrades.ItemListing[]> getTradesMap() {
        return TRADES;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || WorldUtil.isWorld(this.level(), AoADimensions.NOWHERE);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || WorldUtil.isWorld(this.level(), AoADimensions.NOWHERE) && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
    }

    public void setTradingPlayer(@Nullable Player player) {
        super.setTradingPlayer(player);
        this.trading = this.isTrading();
        this.getEntityData().set(TRADING, (Object)this.trading);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(TRADING) && this.level().isClientSide()) {
            this.trading = (Boolean)this.getEntityData().get(TRADING);
        }
    }

    public boolean isPushable() {
        return !WorldUtil.isWorld(this.level(), AoADimensions.NOWHERE) && super.isPushable();
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<SkillMasterEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.create(entityType).health(34.0).moveSpeed(0.2875f).flyingSpeed(0.3f).followRange(32.0).knockbackResist(0.4f);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericIdleController((GeoAnimatable)this), AoAAnimations.genericHeldPoseController(this, AoAAnimations.INTERACT, AoAAnimations.INTERACT_END, entity -> this.trading)});
    }
}

