/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.npc.trader;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.tslat.aoa3.common.menu.CorruptedTravellerMenu;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CorruptedTravellerEntity
extends PathfinderMob
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CorruptedTravellerEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AoAMeleeMob.class, 8.0f, 0.8, 1.0));
        this.goalSelector.addGoal(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !WorldUtil.isWorld(this.level(), AoADimensions.OVERWORLD);
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType spawnReason) {
        return super.checkSpawnRules(level, spawnReason) && level.getEntitiesOfClass(CorruptedTravellerEntity.class, this.getBoundingBox().inflate(16.0, 16.0, 16.0)).isEmpty();
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (this.tickCount == 0) {
            this.setGlowingTag((Boolean)AoAConfigs.SERVER.easyCorruptedTravellers.get());
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result;
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.getItem() == Items.NAME_TAG && (result = heldStack.interactLivingEntity(player, (LivingEntity)this, hand)).consumesAction()) {
            return result;
        }
        if (this.isAlive() && !player.isShiftKeyDown()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                this.openScreen(pl);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    protected void openScreen(ServerPlayer player) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return CorruptedTravellerEntity.this.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int screenId, Inventory inv, Player player) {
                return new CorruptedTravellerMenu(screenId, player.getInventory(), CorruptedTravellerEntity.this);
            }
        }, buffer -> buffer.writeInt(this.getId()));
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<CorruptedTravellerEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.create(entityType).health(50.0).moveSpeed(0.329).followRange(16.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

