/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.npc.ambient;

import com.google.common.base.Suppliers;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntityDataSerializers;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.variant.DryadSpriteVariant;
import net.tslat.aoa3.content.entity.base.AoAAmbientNPC;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.DefaultAnimations;

public class DryadSpriteEntity
extends AoAAmbientNPC {
    private static final EntityDataHolder<DryadSpriteVariant> VARIANT = EntityDataHolder.register(DryadSpriteEntity.class, (EntityDataSerializer)AoAEntityDataSerializers.DRYAD_SPRITE_VARIANT.get(), (DryadSpriteVariant)DryadSpriteVariant.WOOD.get(), entity -> entity.variant, (entity, value) -> {
        entity.variant = value;
    });
    private static final EntityDataHolder<Optional<UUID>> OWNER = EntityDataHolder.register(DryadSpriteEntity.class, EntityDataSerializers.OPTIONAL_UUID, Optional.empty(), entity -> entity.owner, (entity, uuid) -> {
        entity.owner = uuid;
    });
    private static final EntityDataHolder<Integer> SUCCESS_TIMER = EntityDataHolder.register(DryadSpriteEntity.class, EntityDataSerializers.INT, -1, entity -> entity.successTimer, (entity, value) -> {
        entity.successTimer = value;
    });
    private DryadSpriteVariant variant = (DryadSpriteVariant)DryadSpriteVariant.WOOD.get();
    private Optional<UUID> owner = Optional.empty();
    private int successTimer = -1;

    public DryadSpriteEntity(EntityType<? extends DryadSpriteEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, VARIANT, OWNER, SUCCESS_TIMER);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(world, difficulty, reason, spawnData);
        VARIANT.set((Entity)this, DryadSpriteVariant.getVariantForSpawn(world.getLevel(), difficulty, reason, this, (Supplier<Holder<Biome>>)Suppliers.memoize(() -> this.level().getBiome(this.blockPosition())), spawnData));
        return spawnData;
    }

    @Override
    @Nullable
    protected String getInteractMessage(ItemStack heldItem) {
        if (heldItem.isEmpty()) {
            return this.getType().getDescriptionId() + ".interact.empty";
        }
        if (!heldItem.getItem().canPerformAction(heldItem, ItemAbilities.HOE_TILL)) {
            return this.getType().getDescriptionId() + ".interact.incorrect";
        }
        return null;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!source.is(Tags.DamageTypes.IS_TECHNICAL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void setOwner(ServerPlayer owner) {
        OWNER.set((Entity)this, Optional.of(owner.getUUID()));
    }

    @Override
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive() && this.isOwner((Entity)player) && SUCCESS_TIMER.is((Entity)this, -1)) {
            ItemStack heldStack = player.getItemInHand(hand);
            if (OWNER.get((Entity)this).isEmpty()) {
                OWNER.set((Entity)this, Optional.of(player.getUUID()));
            }
            if (heldStack.canPerformAction(ItemAbilities.HOE_TILL)) {
                if (this.getVariant().isCorrectOffering(heldStack)) {
                    if (!this.level().isClientSide()) {
                        SUCCESS_TIMER.set((Entity)this, 44);
                        player.awardKillScore((Entity)this, 1, this.level().damageSources().playerAttack(player));
                        this.navigation.stop();
                        this.setDeltaMovement(0.0, 0.0, 0.0);
                    }
                } else if (!this.level().isClientSide) {
                    this.discard();
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)AoASounds.ENTITY_DRYAD_SPRITE_UNHAPPY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    for (int i = 0; i < 20; ++i) {
                        ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, (Entity)this).velocity(RandomUtil.randomScaledGaussianValue((double)0.02), RandomUtil.randomScaledGaussianValue((double)0.02), RandomUtil.randomScaledGaussianValue((double)0.02)).sendToAllPlayersTrackingEntity((ServerLevel)this.level(), (Entity)this);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public DryadSpriteVariant getVariant() {
        return this.variant;
    }

    public void checkDespawn() {
        super.checkDespawn();
        if (!this.isRemoved() && this.tickCount > 100 && SUCCESS_TIMER.is((Entity)this, -1)) {
            this.discard();
        }
    }

    protected void customServerAiStep() {
        if (this.successTimer > 0) {
            SUCCESS_TIMER.set((Entity)this, this.successTimer - 1);
        } else if (this.successTimer == 0) {
            TELParticlePacket packet = new TELParticlePacket();
            for (int i = 0; i < 20; ++i) {
                packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (Entity)this).velocity(this.rand().randomScaledGaussianValue(0.02), this.rand().randomScaledGaussianValue(0.02), this.rand().randomScaledGaussianValue(0.02)));
            }
            packet.sendToAllPlayersTrackingEntity((ServerLevel)this.level(), (Entity)this);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)AoASounds.ENTITY_DRYAD_SPRITE_HAPPY.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)this.random.nextInt(10, 20));
            }
            OWNER.get((Entity)this).ifPresent(ownerId -> {
                this.setHealth(0.0f);
                Player player = this.level().getPlayerByUUID(ownerId);
                if (player != null) {
                    this.setLastHurtByPlayer(player);
                    DamageSource damageSource = this.damageSources().playerAttack(player);
                    if (this.deathScore >= 0) {
                        player.awardKillScore((Entity)this, this.deathScore, damageSource);
                    }
                    this.dead = true;
                    this.getCombatTracker().recheckStatus();
                    if (player.killedEntity((ServerLevel)this.level(), (LivingEntity)this)) {
                        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                        this.dropAllDeathLoot((ServerLevel)this.level(), damageSource);
                        this.createWitherRose((LivingEntity)player);
                    }
                }
            });
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public boolean isOwner(Entity entity) {
        return OWNER.get((Entity)this).map(value -> value.equals(entity.getUUID())).orElse(true);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<DryadSpriteEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(5.0).moveSpeed(0.329).followRange(16.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, state -> {
            if (SUCCESS_TIMER.get((Entity)this) >= 0) {
                return state.setAndContinue(AoAAnimations.SUCCEED);
            }
            return state.setAndContinue(state.isMoving() ? DefaultAnimations.WALK : DefaultAnimations.IDLE);
        }));
    }
}

