/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.precasia;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoAFluidTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntityDataSerializers;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.common.registration.entity.variant.VeloraptorVariant;
import net.tslat.aoa3.content.entity.animal.precasia.OpteryxEntity;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyLivingEntitySensor;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.brain.task.temp.FixedTargetOrRetaliate;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.aoa3.util.MathUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;

public class VeloraptorEntity
extends AoAMeleeMob<VeloraptorEntity> {
    private static final EntityDataHolder<VeloraptorVariant> VARIANT = EntityDataHolder.register(VeloraptorEntity.class, (EntityDataSerializer)AoAEntityDataSerializers.VELORAPTOR_VARIANT.get(), (VeloraptorVariant)VeloraptorVariant.GREEN.get(), entity -> entity.variant, (entity, value) -> {
        entity.variant = value;
    });
    private static final AttributeModifier LUNGE_DAMAGE_MODIFIER = new AttributeModifier(AdventOfAscension.id("lunge_damage"), 3.0, AttributeModifier.Operation.ADD_VALUE);
    private static final int ATTACK_BITE = 0;
    private static final int ATTACK_POUNCE = 1;
    private VeloraptorVariant variant = (VeloraptorVariant)VeloraptorVariant.GREEN.get();

    public VeloraptorEntity(EntityType<? extends VeloraptorEntity> entityType, Level level) {
        super((EntityType<? extends AoAMeleeMob>)entityType, level);
        this.setParts(new AoAEntityPart<VeloraptorEntity>(this, this.getBbWidth(), 0.9375f, 0.0f, 1.0f, this.getBbWidth()).setDamageMultiplier(1.1f));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, VARIANT);
    }

    @Override
    protected double getAttackReach() {
        return 1.11f;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_RAPTOR_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_SPINOLEDON_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_RAPTOR_DEATH.get();
    }

    @Override
    public List<ExtendedSensor<? extends VeloraptorEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new AggroBasedNearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null || target instanceof OpteryxEntity || target instanceof Sniffer;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<VeloraptorEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(entity.distanceToSqr((Entity)target) < 8.0 ? 1.0f : 1.2f)), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AnimatableMeleeAttack(7).attackInterval(entity -> 8).whenStarting(entity -> ATTACK_STATE.set((Entity)entity, 0)).whenStopping(entity -> BrainUtils.setSpecialCooldown((LivingEntity)this, (int)8)), (Object)5), Pair.of((Object)new LungeMeleeAttack(15).startCondition(Entity::onGround), (Object)1)}).startCondition(entity -> !BrainUtils.isOnSpecialCooldown((LivingEntity)this))});
    }

    @Override
    public BrainActivityGroup<? extends VeloraptorEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FixedTargetOrRetaliate<Mob>().alertAlliesWhen((entity, target) -> target instanceof Player || target instanceof Animal).useMemory((MemoryModuleType<LivingEntity>)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.level().isDay() ? entity.getRandom().nextInt(30, 60) : entity.getRandom().nextInt(60, 120))})});
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Variant", AoARegistries.VELORAPTOR_VARIANTS.getKey(VARIANT.get((Entity)this)).toString());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Variant", 8)) {
            VARIANT.set((Entity)this, AoARegistries.VELORAPTOR_VARIANTS.getEntry(ResourceLocation.tryParse((String)compound.getString("Variant"))));
        }
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.tickCount % 100 == 0) {
            if (!this.level().isDay()) {
                AttributeUtil.applyTransientModifier((LivingEntity)this, AoAAttributes.AGGRO_RANGE, AoAAttributes.NIGHT_AGGRO_MODIFIER);
            } else {
                AttributeUtil.removeModifier((LivingEntity)this, AoAAttributes.AGGRO_RANGE, AoAAttributes.NIGHT_AGGRO_MODIFIER);
            }
        }
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (damageContainer.getSource().is(DamageTypeTags.IS_FIRE) && this.level().getFluidState(BlockPos.containing((Position)this.getEyePosition())).getFluidType() == AoAFluidTypes.TAR.get() && this.level().getFluidState(this.blockPosition().above()).getFluidType() == AoAFluidTypes.TAR.get()) {
                ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.LARGE_SMOKE, (Entity)this).colourOverride(255, 255, 255, 255).spawnNTimes(20).sendToAllPlayersTrackingEntity(level2, (Entity)this);
                if (this.isDeadOrDying()) {
                    AoAScheduler.scheduleSyncronisedTask(() -> EntitySpawningUtil.spawnEntity(level2, (EntityType)AoAMonsters.SKELETAL_ABOMINATION.get(), this.position(), MobSpawnType.CONVERSION, abomination -> {
                        abomination.setXRot(this.getXRot());
                        abomination.setYRot(this.getYRot());
                        abomination.setYHeadRot(this.getYHeadRot());
                    }), 19 - this.deathTime);
                }
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(world, difficulty, reason, spawnData);
        VARIANT.set((Entity)this, VeloraptorVariant.getVariantForSpawn(world.getLevel(), difficulty, reason, this, (Supplier<Holder<Biome>>)Suppliers.memoize(() -> this.level().getBiome(this.blockPosition())), spawnData));
        return spawnData;
    }

    public VeloraptorVariant getVariant() {
        return this.variant;
    }

    @Override
    protected int getAttackSwingDuration() {
        return ATTACK_STATE.is((Entity)this, 0) ? 8 : 40;
    }

    @Override
    protected int getPreAttackTime() {
        return ATTACK_STATE.is((Entity)this, 0) ? 4 : 21;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.getVariant().lootTable().orElseGet(() -> super.getDefaultLootTable());
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_NIGHT_MONSTER.noLowerThanY(60).difficultyBasedSpawnChance(0.1f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<VeloraptorEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(37.0).moveSpeed(0.35).meleeStrength(7.5).knockbackResist(0.2f).aggroRange(16.0).followRange(32.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkRunIdleController((Entity)this));
        controllers.add(new AnimationController((GeoAnimatable)this, "attacking", 0, state -> {
            if (this.swinging) {
                if (ATTACK_STATE.is((Entity)this, 0)) {
                    state.setControllerSpeed(1.0f);
                    return state.setAndContinue(DefaultAnimations.ATTACK_BITE);
                }
                state.setControllerSpeed(1.5f);
                return state.setAndContinue(AoAAnimations.ATTACK_POUNCE);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
    }

    public static class LungeMeleeAttack
    extends AnimatableMeleeAttack<VeloraptorEntity> {
        public LungeMeleeAttack(int delayTicks) {
            super(delayTicks);
            this.attackInterval(entity -> 30);
        }

        protected boolean checkExtraStartConditions(ServerLevel level, VeloraptorEntity entity) {
            this.target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            double targetDist = BrainUtils.getTargetOfEntity((LivingEntity)entity).distanceToSqr((Entity)entity);
            return entity.isSprinting() && targetDist > 8.0 && targetDist <= 30.0 && entity.getSensing().hasLineOfSight((Entity)this.target);
        }

        protected void start(VeloraptorEntity entity) {
            super.start((Mob)entity);
            AoAMonster.ATTACK_STATE.set((Entity)entity, 1);
            entity.getNavigation().stop();
            Vec3 oldPos = this.target.position();
            AoAScheduler.scheduleSyncronisedTask(() -> {
                LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
                Vec3 lungePos = target != null ? target.position().add(oldPos.vectorTo(target.position())) : entity.position().add(entity.getLookAngle().scale(4.0));
                entity.setDeltaMovement(MathUtil.clampVec(entity.getDeltaMovement().add(entity.position().vectorTo(lungePos).scale(0.7777777910232544).add(0.0, (double)0.1f, 0.0)), new Vec3(-1.2, (double)-0.1f, (double)-1.2f), new Vec3(1.2, 0.5, (double)1.2f)));
            }, 9);
        }

        protected void stop(VeloraptorEntity entity) {
            super.stop((Mob)entity);
            BrainUtils.setSpecialCooldown((LivingEntity)entity, (int)40);
        }

        protected void doDelayedAction(VeloraptorEntity entity) {
            AttributeUtil.applyTransientModifier((LivingEntity)entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, LUNGE_DAMAGE_MODIFIER);
            super.doDelayedAction((Mob)entity);
            AttributeUtil.removeModifier((LivingEntity)entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, LUNGE_DAMAGE_MODIFIER);
        }
    }
}

