/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.precasia;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.block.AoAFluidTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.util.DamageUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SkeletalAbominationEntity
extends AoAMeleeMob<SkeletalAbominationEntity> {
    public static final EntityDataHolder<Boolean> STANDING = EntityDataHolder.register(SkeletalAbominationEntity.class, EntityDataSerializers.BOOLEAN, false, entity -> entity.standing, SkeletalAbominationEntity::setStanding);
    private static final RawAnimation POSE_ANIM_STAND = RawAnimation.begin().thenPlay("misc.stand").thenLoop("misc.stand.hold");
    private static final RawAnimation POSE_ANIM_RELEASE = RawAnimation.begin().thenPlay("misc.stand.release");
    private static final RawAnimation WALK_ANIM_BIPED = RawAnimation.begin().thenPlay("move.walk.biped");
    private static final int ATTACK_BITE = 0;
    private static final int ATTACK_THROW = 1;
    private static final int ATTACK_SWING = 2;
    private static final int ATTACK_SLAM = 3;
    private boolean standing = false;

    public SkeletalAbominationEntity(EntityType<? extends SkeletalAbominationEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.setParts(new AoAEntityPart<SkeletalAbominationEntity>(this, this.getBbWidth() * 0.75f, this.getBbHeight() * 0.75f, 0.0f, this.getBbHeight() * 0.65f, this.getBbWidth() * 0.875f), new AoAEntityPart<SkeletalAbominationEntity>(this, this.getBbWidth() * 0.75f, this.getBbHeight() * 0.5f, 0.0f, this.getBbHeight(), this.getBbWidth() * 1.625f).setDamageMultiplier(1.25f), new AoAEntityPart<SkeletalAbominationEntity>(this, this.getBbWidth(), this.getBbHeight() * 0.9f, 0.0f, 0.0f, -this.getBbWidth()).setDamageMultiplier(0.75f));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, STANDING);
    }

    public boolean isStanding() {
        return this.standing;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("StandingUp", this.standing);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("StandingUp")) {
            STANDING.set((Entity)this, compound.getBoolean("StandingUp"));
        }
    }

    public void makeStuckInBlock(BlockState state, Vec3 pMotionMultiplier) {
        if (!state.is((Block)AoABlocks.TAR.getBlock())) {
            super.makeStuckInBlock(state, pMotionMultiplier);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void jumpInFluid(FluidType type) {
        if (this.getNavigation().canFloat() && type == AoAFluidTypes.TAR.get()) {
            this.self().setDeltaMovement(this.self().getDeltaMovement().add(0.0, (double)0.4f * this.self().getAttributeValue(NeoForgeMod.SWIM_SPEED), 0.0));
        } else {
            super.jumpInFluid(type);
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (DamageUtil.isRangedDamage(source) || DamageUtil.isGunDamage(source)) {
            amount *= 0.5f;
        }
        return super.hurt(source, amount);
    }

    protected void setStanding(boolean standing) {
        if (standing == this.standing) {
            return;
        }
        this.standing = standing;
        if (!this.level().isClientSide) {
            STANDING.set((Entity)this, standing);
        }
        this.toggleMultipart(!standing);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isStanding()) {
            return new EntityDimensions(1.0f, 2.6875f, 5.1190476f, this.getType().getDimensions().attachments(), this.getType().getDimensions().fixed()).scale(this.getScale());
        }
        return super.getDefaultDimensions(pose);
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.isInFluidType((FluidType)AoAFluidTypes.TAR.get()) && this.getHealth() < this.getMaxHealth()) {
            this.heal(2.0f);
        }
    }

    @Override
    public int getCurrentSwingDuration() {
        return switch ((Integer)ATTACK_STATE.get((Entity)this)) {
            case 0 -> 9;
            case 1 -> 18;
            case 2 -> 15;
            case 3 -> 20;
            default -> 9;
        };
    }

    @Override
    protected int getPreAttackTime() {
        return switch ((Integer)ATTACK_STATE.get((Entity)this)) {
            case 0 -> 4;
            case 1 -> 7;
            case 2 -> 6;
            case 3 -> 17;
            default -> 4;
        };
    }

    @Override
    protected double getAttackReach() {
        return 1.5625;
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<SkeletalAbominationEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(64.0).meleeStrength(9.5).moveSpeed(0.35f).aggroRange(32.0).followRange(48.0).knockbackResist(0.15f);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Pose", 0, state -> {
            if (this.isStanding()) {
                return state.setAndContinue(POSE_ANIM_STAND);
            }
            if (state.isCurrentAnimation(POSE_ANIM_STAND) || state.isCurrentAnimation(POSE_ANIM_RELEASE) && !state.getController().hasAnimationFinished()) {
                return state.setAndContinue(POSE_ANIM_RELEASE);
            }
            state.resetCurrentAnimation();
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk/Idle", 3, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.isStanding() ? WALK_ANIM_BIPED : DefaultAnimations.WALK);
            }
            if (!this.isStanding()) {
                return state.setAndContinue(DefaultAnimations.IDLE);
            }
            return PlayState.STOP;
        }));
    }
}

