/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.precasia;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.brain.task.temp.SetRandomFlyingTarget;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class MeganeuropsisEntity
extends AoAMeleeMob<MeganeuropsisEntity> {
    public MeganeuropsisEntity(EntityType<? extends MeganeuropsisEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.moveControl = new MeganeuropsisMoveControl((Mob)this);
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.setCanFloat(true);
        return navigation;
    }

    @Override
    public BrainActivityGroup<? extends MeganeuropsisEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)), new SetRandomFlyingTarget<PathfinderMob>().verticalWeight(entity -> -(entity.getRandom().nextInt(10) == 0 ? 1 : 0)).setRadius(4.0, 4.0).startCondition(entity -> (Boolean)BrainUtils.memoryOrDefault((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.IS_PANICKING, () -> false) == false)});
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AoASounds.ENTITY_MEGANEUROPSIS_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_MEGANEUROPSIS_DEATH.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_MEGANEUROPSIS_AMBIENT.get();
    }

    protected void spawnSprintParticle() {
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState block) {
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean onClimbable() {
        return false;
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (this.rand().oneInNChance(10)) {
                EntityUtil.applyPotions((Entity)livingTarget, new EffectBuilder(MobEffects.CONFUSION, 120).hideParticles());
            }
        }
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_NIGHT_MONSTER.noLowerThanY(65).difficultyBasedSpawnChance(0.05f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<MeganeuropsisEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(19.0).meleeStrength(5.0).moveSpeed(0.33).flyingSpeed(0.33f).aggroRange(8.0).armour(1.0).followRange(16.0);
    }

    private static class MeganeuropsisMoveControl
    extends MoveControl {
        private int cooldown = 0;

        public MeganeuropsisMoveControl(Mob mob) {
            super(mob);
        }

        public void strafe(float pForward, float pStrafe) {
            this.operation = MoveControl.Operation.STRAFE;
            this.strafeForwards = pForward;
            this.strafeRight = pStrafe;
            this.speedModifier = 0.5;
        }

        public void tick() {
            if (this.mob.tickCount > 0) {
                if (this.cooldown < this.mob.tickCount) {
                    this.cooldown = 0;
                } else {
                    this.mob.setSpeed(0.0f);
                    this.mob.setDeltaMovement(this.mob.getDeltaMovement().scale(0.5));
                    this.mob.setYya(0.0f);
                    this.mob.setZza(0.0f);
                    return;
                }
            }
            if (this.operation == MoveControl.Operation.STRAFE) {
                this.mob.setNoGravity(true);
                this.operation = MoveControl.Operation.WAIT;
                float moveSpeed = (float)(this.speedModifier * this.mob.getAttributeValue(this.mob.onGround() ? Attributes.MOVEMENT_SPEED : Attributes.FLYING_SPEED));
                this.mob.setSpeed(moveSpeed);
                this.mob.setZza(this.strafeForwards);
                this.mob.setXxa(this.strafeRight);
            } else if (this.operation == MoveControl.Operation.MOVE_TO) {
                this.mob.setNoGravity(true);
                this.operation = MoveControl.Operation.WAIT;
                double distX = this.wantedX - this.mob.getX();
                double distY = this.wantedY - this.mob.getY();
                double distZ = this.wantedZ - this.mob.getZ();
                double distSq = distX * distX + distY * distY + distZ * distZ;
                if (distSq < 0.9) {
                    this.mob.setYya(0.0f);
                    this.mob.setZza(0.0f);
                    this.cooldown = this.mob.tickCount + 20;
                    return;
                }
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), (float)(Mth.atan2((double)distZ, (double)distX) * 57.2957763671875) - 90.0f, 180.0f));
                float moveSpeed = (float)(this.speedModifier * this.mob.getAttributeValue(this.mob.onGround() ? Attributes.MOVEMENT_SPEED : Attributes.FLYING_SPEED));
                double lateralDist = Math.sqrt(distX * distX + distZ * distZ);
                this.mob.setSpeed(moveSpeed);
                this.mob.setZza(2.0f);
                if (Math.abs(distY) > 0.75 || Math.abs(lateralDist) > 0.75) {
                    float angle = (float)(-(Mth.atan2((double)distY, (double)lateralDist) * 57.2957763671875));
                    this.mob.setXRot(this.rotlerp(this.mob.getXRot(), angle, 1.0f));
                    this.mob.setYya(distY > 0.0 ? moveSpeed : -moveSpeed);
                } else {
                    this.mob.setSpeed(0.0f);
                }
            } else {
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
            }
        }
    }
}

